/* routines to read big-endian integers from a byte file.
 * This file should work on \both/ little- and big-endian machines.
 * It's assumed that int==long; and that integers are binary, 2's complement
 * and the machine is byte-addressable. It's easy to get around these
 * assumptions, but it seems not to be worthwhile.
 * Per Bothner, December 1984.
 */
#include <stdio.h>
#define u_char unsigned char
#define u_long unsigned long
#define s_char char
#define u_getc(fp) ((u_char)getc(fp))
#define s_getc(fp) ((s_char)getc(fp))

GetSigned1(fp)
    FILE *fp;
  {
    return s_getc(fp);
  }

GetSigned2(fp)
    FILE *fp;
  { register long w = getc(fp);
    if (w >= 128) w -= 256;
    return w*256+u_getc(fp);
  }

long
GetSigned3(fp)
    FILE *fp;
  { int a, b, c;
    a = u_getc(fp);
    b = u_getc(fp);
    c = u_getc(fp);
    if (a >= 128) a -= 256;
    return (a*256+b)*256+c;
  }

GetSigned4(fp)
    FILE *fp;
  { long a, b, c, d;
    a = u_getc(fp);
    b = u_getc(fp);
    c = u_getc(fp);
    d = u_getc(fp);
    if (a >= 128) a -= 256;
    return ((a*256+b)*256+c)*256+d;
  }

GetUnsigned1(fp)
    FILE *fp;
  {
    return u_getc(fp);
  }

GetUnsigned2(fp)
    FILE *fp;
  { register long w = u_getc(fp);
    return w*256+u_getc(fp);
  }

u_long
GetUnsigned3(fp)
    FILE *fp;
  {
    return GetSigned3(fp) & 0xFFFFFF;
  }

u_long
GetUnsigned4(fp)
    FILE *fp;
  { /* the 0xFFFFFFFF is in case of a >32-bit word length */ 
    return (u_long)GetSigned4(fp) & 0xFFFFFFFF;
  }
