/*
*	This file is identical to /usr/include/a.out.h except that
*	the field names are changed to correspond to those used in
*	the (cc68) b.out.h header.  The fields ARE in a different 
*       order, as the C compiler generates things in the a.out 
*	header format.  So There.
*/

/*
 * Header prepended to each a.out file.
 */
struct bhdr {
	long	fmagic;	/* magic number */
unsigned long	tsize;		/* size of text segment */
unsigned long	dsize;		/* size of initialized data */
unsigned long	bsize;		/* size of uninitialized data */
unsigned long	ssize;		/* size of symbol table */
unsigned long	entry;		/* entry point */
unsigned long	rtsize;		/* size of text relocation */
unsigned long	rdsize;		/* size of data relocation */
};

#define	OMAGIC	0407		/* old impure format */
#define	NMAGIC	0410		/* read-only text */
#define	ZMAGIC	0413		/* demand load format */

#define	SEGSIZE	1024		/* NMAGIC and ZMAGIC files require some */
				/* info. to be aligned on 1K boundaries */
/*
 * Macros which take bhdr structures as arguments and tell whether
 * the file has a reasonable magic number or offsets to text|symbols|strings.
 */
#define	N_BADMAG(x) \
    (((x).fmagic)!=OMAGIC && ((x).fmagic)!=NMAGIC && ((x).fmagic)!=ZMAGIC)

#define	N_TXTOFF(x) \
	((x).fmagic==ZMAGIC ? SEGSIZE : sizeof (struct bhdr))
#define N_SYMOFF(x) \
	(N_TXTOFF(x) + (x).tsize+(x).dsize + (x).rtsize+(x).rdsize)
#define	N_STROFF(x) \
	(N_SYMOFF(x) + (x).ssize)

/*
 * Format of a relocation datum.
 */
struct relocation_info {
	int	r_address;	/* address which is relocated */
unsigned int	r_symbolnum:24,	/* local symbol ordinal */
		r_pcrel:1, 	/* was relocated pc relative already */
		r_length:2,	/* 0=byte, 1=word, 2=long */
		r_extern:1,	/* does not include value of sym referenced */
		:4;		/* nothing, yet */
};

/*
 * Format of a symbol table entry; this file is included by <a.out.h>
 * and should be used if you aren't interested the a.out header
 * or relocation information.
 */
struct	nlist {
	union {
		char	*n_name;	/* for use when in-core */
		long	n_strx;		/* index into file string table */
	} n_un;
unsigned char	n_type;		/* type flag, i.e. N_TEXT etc; see below */
	char	n_other;	/* unused */
	short	n_desc;		/* see <stab.h> */
unsigned long	n_value;	/* value of this symbol (or sdb offset) */
};
#define	n_hash	n_desc		/* used internally by ld */

/*
 * Simple values for n_type.
 */
#define	N_UNDF	0x0		/* undefined */
#define	N_ABS	0x2		/* absolute */
#define	N_TEXT	0x4		/* text */
#define	N_DATA	0x6		/* data */
#define	N_BSS	0x8		/* bss */
#define	N_COMM	0x12		/* common (internal to ld) */
#define	N_FN	0x1f		/* file name symbol */

#define	N_EXT	01		/* external bit, or'ed in */
#define	N_TYPE	0x1e		/* mask for all the type bits */

/*
 * Sdb entries have some of the N_STAB bits set.
 * These are given in <stab.h>
 */
#define	N_STAB	0xe0		/* if any of these bits set, a SDB entry */

/*
 * Format for namelist values.
 */
#define	N_FORMAT	"%08x"
