/*
 * implementation of spin locks
 *
 * for the microVAX
 *
 * the _<op>SpinLock kludge is required because the VAX compiler
 *	prepends '_' to global symbols
 *
 * the _<op> forms are internal only and should not be used in programs
 */

#ifndef V_SPINLOCK
#define V_SPINLOCK


#define SpinLockLocked (0x80000000)
#define SpinLockUnlocked (0)

typedef unsigned SpinLockType;
struct SpinLockStruct {
    short lock;
    short count;
  };

#define SpinLockCount(l)	(((struct SpinLockStruct *) &(l))->count)


#define AcquireArgumentSpinLock() 	\
  do					\
  {					\
    asm("pushl r3");			\
    asm("movl 4(ap),r3");		\
     asm("	brb	2f");		\
     asm("1:	");			\
     asm("	incw	2(r3)");	\
     Delay(0,1);			\
     asm("2:	bbssi	$7,0(r3),1b");	\
    asm("movl  (sp)+,r3");		\
  } while(0)

#define ReleaseArgumentSpinLock() 	\
  do					\
  {					\
    asm("pushl r3");			\
    asm("movl 4(ap),r3");		\
    _ReleaseGlobalSpinLock(0(r3))	\
    asm("movl  (sp)+,r3");		\
  } while(0)


#define AcquireGlobalSpinLock(lockName) _AcquireGlobalSpinLock(_/**/lockName)

#define _AcquireGlobalSpinLock(lockName)	\
  do					\
  {					\
    asm("	brb	2f");		\
    asm("1:	");			\
    asm("	incw	lockName+2");	\
    Delay(0,1);				\
    asm("2:	bbssi	$7,lockName,1b");		\
  } while(0)

#define ReleaseGlobalSpinLock(lockName) _ReleaseGlobalSpinLock(_/**/lockName)

#define _ReleaseGlobalSpinLock(lockName) \
    do { asm("	clrb lockName"); } while(0)

extern void AcquireSpinLock();
extern void ReleaseSpinLock();

#endif V_SPINLOCK
