/*
 * V Copyright (c) 1983 by David Cheriton, all rights reserved.
 *
 * V team interface manifests and message formats.
 */

#ifndef VTEAM
#define VTEAM
#include "Vio.h"


/*
 * Stdio defns.
 */

typedef unsigned long LongInstanceId;	/* For future expansion */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		replycode;
    unsigned short	rootflags;	/* Flags; see below */
#else LITTLE_ENDIAN
    unsigned short	rootflags;
    SystemCode		replycode;
#endif LITTLE_ENDIAN
    ProcessId		stdinserver;	/* Standard I/O instances */
    LongInstanceId	stdinfile;
    ProcessId		stdoutserver;
    LongInstanceId  	stdoutfile;
    ProcessId		stderrserver;
    LongInstanceId	stderrfile;
    char		*envblock;	/* Location of team env block */
  }
RootMessage;

/* Byte swap a RootMessage from a different-endian host.  NOTE: This is 
 * needed only if the RootMessage was passed in a SEGMENT.
 */
#define ByteSwapRootMessage(rm) do { \
    ByteSwapLongInPlace((rm), 1*sizeof(long)); \
    ByteSwapLongInPlace(&((rm)->stdinserver), 7*sizeof(long)); \
  } while (0)


/* Root flags - bit assignments */

#define RELEASE_INPUT		0x0010	/* Release std input on close */
#define RELEASE_OUTPUT		0x0020  /* Release std output on close */
#define RELEASE_ERR		0x0040	/* Release err output on close */
#define STDOUT_APPEND		0x0001 	/* Open std output in append mode */
#define STDERR_APPEND		0x0080	/* Open std err output for append */

/* Request codes. */  
#define TeamLoadRequest 0x3800
#define UpdateRequest 0x3C01
#define CHANGE_TEAM_PRIORITY 0x0010
#define GET_TEAM_PRIORITY 0x0011
#define MIGRATION_REQUEST 0x5c12
#define TRANSFER_HOST_REQUEST 0x5813
#define REDO_MIGRATION_REQUEST 0x5c14

/* DESTROY_HOST request types. */
#define MIGRATED_HOST 1
#define KILL_HOST 2

/* Various request types. */
#define SpecificTeam 0
#define AllTeams 1
#define RequestorTeams 2

#define UpdateInformation 0
#define ReturnInformation 1
#define GetHostStatus 3
#define GetLongHostStatus 4

/* Scheduling classes for teams.
   NOTE: the constants used are NOT arbitrary. */
#define REAL_TIME1		1
#define REAL_TIME2		2
#define REAL_TIME3		3
#define REAL_TIME4		4
#define FOREGROUND		5
#define BACKGROUND		6
#define STOP_TEAM_PRIORITY	7
#define GUEST			8

/*
 * Request & Reply Message Formats
 */

typedef struct			/* Team load request message */
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    InstanceId	fileid;		/* Server file instance to load from. */
#else LITTLE_ENDIAN
    InstanceId	fileid;		/* Server file instance to load from. */
    SystemCode	requestcode;
#endif LITTLE_ENDIAN
    ProcessId	fileserver;	/* Server to load from. */
    int		noOwner;	/* True if the loaded team should be owned by
				   the system rather than the requestor. */
    unsigned	unspecified[3];
    char	*bufferptr;	/* Points to additional load parameters such
				   as the io file instances. */
    unsigned	bytecount;
  } LoadTeamRequest;

typedef struct			/* Team load reply message */
  {
#ifndef LITTLE_ENDIAN
    SystemCode	replycode;
    short	fill;
#else LITTLE_ENDIAN
    short	fill;
    SystemCode	replycode;
#endif LITTLE_ENDIAN
    ProcessId	rootPid;	/* Pid of root process of loaded team */
    char	*teamend;	/* End of code+data+bss of loaded team */
    unsigned	unused[5];
  } LoadTeamReply;

typedef struct			/* Team termination request message */
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    short	requestType;	/* Specifies whether to terminate a specific
				   team, all the requestor's teams, or all
				   teams. */
#else LITTLE_ENDIAN
    short	requestType;	/* Specifies whether to terminate a specific
				   team, all the requestor's teams, or all
				   teams. */
    SystemCode	requestcode;
#endif LITTLE_ENDIAN
    ProcessId	rootPid;	/* Root process pid of specific team to
				   terminate. */
    int		status;		/* Status code associated with the
				   termination. */
  } ExitTeamRequest;

typedef LoadTeamReply ExitTeamReply;

typedef struct			/* Host status update message */
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    short	requesttype;	/* Flags whether new status is being supplied
				   or requested. */
#else LITTLE_ENDIAN
    short	requesttype;	/* Flags whether new status is being supplied
				   or requested. */
    SystemCode	requestcode;
#endif LITTLE_ENDIAN
    int		availability;	/* New status of host's availability for
				   remote execution. */
    unsigned	unspecified[4];
    char	*bufferptr;	/* Points to user's login name. */
    unsigned	bytecount;
  } UpdateHostStatusRequest;

typedef UpdateHostStatusRequest UpdateHostStatusReply;


/*
 * NOTE: Not a message structure.  Does not need to have byte order specs.
 */

typedef struct			/* Descriptor record for host selection. */
  {
    char *hostName;		/* NULL => no selection on this field. */
    unsigned char freeTeams;
    unsigned short freeProcs;
    int minFreeMem;
    int maxFreeMem;
    int minIdleTime;
    int maxIdleTime;
    unsigned short procMachType;
    ProcessId teamServerPid;
  }
    SelectionRec;


typedef struct HostStatusType
  {
    char hostName[32];
    char userName[32];		/* Name of host's user. */
    int availability;		/* Availability of the host wrt. remote
				   execution requests.  -1 is used to
				   represent absolute unavailability; i.e.
				   absolutely no remote load requests 
				   allowed.  -1 is turned into 0 for purposes
				   of answering status queries. */
    int userNumber;		/* User number of person logged in. */
  }
    HostStatusRecord;


#define HOST_STATUS 1
#define HOST_NAME 3
#define AVAIL_RELEVANT (char) 0x1
#define AVAILABLE (char) 0x2

#define	PROC_FAMILY_FIELD	0xF
#define	PROC_FAMILY_IRRELEVANT	0xF
#define MACH_TYPE_FIELD		0xF0
#define MACH_TYPE_IRRELEVANT	0xF
#define MACH_TYPE_SHIFT		4
#define PROC_TYPE_FIELD		0xFF00
#define PROC_TYPE_IRRELEVANT	0xFF
#define PROC_TYPE_SHIFT		8

#define YOUR_LOOKING_FOR_ME OK


struct hostStatMsg {

#ifndef LITTLE_ENDIAN
    SystemCode  	requestcode ;
    short       	kernelVersionNo ; /* will be added later */
    char		avail ;
    unsigned char	freeTeams ;
    unsigned short	freeProcs ;
#else
    short       	kernelVersionNo ; /* will be added later */
    SystemCode  	requestcode ;
    unsigned short	freeProcs ;
    unsigned char	freeTeams ;
    char		avail ;
#endif
    int			minFreeMem ;
    int 		maxFreeMem ;
    int			minIdleTime ;
    int			maxIdleTime ;
#ifndef LITTLE_ENDIAN
    unsigned short	procMachType ;
    unsigned short	conf1; 
#else
    unsigned short	conf1; 
    unsigned short	procMachType ;
#endif
    unsigned		conf2 ;

    /* and a ninth word that is not part of message but needed in many
     * cases to store pid of respondant */
    ProcessId		pid ;
} ;

#endif
