/*
 * V Copyright (c) 1982 by David Cheriton, all rights reserved.
 * (Transliterated from Zed and Verex)
 *
 * V session interface manifests and message formats.
 */

#ifndef VSESSION
#define VSESSION
#include "Venviron.h"

/* Note that LookupServerRequest/Reply will soon become obsolete */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    short	fill1;
#else LITTLE_ENDIAN
    short	fill1;
    SystemCode	requestcode;
#endif LITTLE_ENDIAN
    short	fill2[10];
    char	*hostname;
    unsigned	namelength;
  } LookupServerRequest;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode	replycode;
    short	fill1;
#else LITTLE_ENDIAN
    short	fill1;
    SystemCode	replycode;
#endif LITTLE_ENDIAN
    short	fill2[2];
    ProcessId	serverpid;
  } LookupServerReply;

/* Add/delete a correspondence between V user number and a user name on a remote
 * host that provides a session.  For ADD_USER_CORRESPONDENCE, a segment is 
 * also passed.  This segment consists of a user name (on the remote host), 
 * followed by a password.  Each is 0-terminated.  No such segment is required
 * for DELETE_USER_CORRESPONDENCE.
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;	/* ADD/DELETE_USER_CORRESPONDENCE */
    short 		unused;
#else LITTLE_ENDIAN
    short 		unused;
    SystemCode		requestcode;	/* ADD/DELETE_USER_CORRESPONDENCE */
#endif LITTLE_ENDIAN
    unsigned		vUserNumber;
    int			filler[4];	
    char		*segmentptr;	/* ADD_USER_CORRESPONDENCE only */
    unsigned		segmentlen;	/*	"	"	"	*/
  } UserCorrespondenceRequest;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		replycode;
    short 		unused;
#else LITTLE_ENDIAN
    short 		unused;
    SystemCode		replycode;
#endif LITTLE_ENDIAN
    int			filler[7];	
  } UserCorrespondenceReply;


/* A special request code for requesting debugging information about 
   currently maintained instances. */
#define GET_INSTANCE_INFO 0x4486

#endif VSESSION
