/*
* V - Copright 1982 (c) David Cheriton, all rights reserved.
*
*   Network server manifests, struct and type definitions.
*
*/

#ifndef VNET
#define VNET


/* Connection types.
*  These go into the "filetype" field of a CREATE_INSTANCE request. 
*/
#define IPtype 0
#define TCPtype 1
#define PUPtype 2
#define ICMPtype 3
#define GTWtype 4


/* Release Request Types
*/  
#define REL_STANDARD		0
#define REL_ABORT		203    	/*  Only used to abort TCP */


/* ModifyFile parameter specifications
*/
#define ModTcpTimeout 0
#define ModTcpUrgFlag 1


/* Default Tcp instance parameters
*/
#define DefaultTcpPrecedence 0
#define DefaultTcpSecurity 0

/* Tcp connection instance "special" events.
*/
#define BEGIN_URGENT_DATA	0x8002	/* means URG flag has appeared */
#define END_URGENT_DATA		0x8003	/* means URGENT pointer has arrived */


#define UrgentData 0x8002		/* Signals that urgent data is 
					   present. OBSOLETE */



/*
*    TYPE DEFINITIONS
*/

/* Request & Reply Message Formats
*/
typedef struct				/*  NQuery File Request */
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    short unsigned nameindex;
    short unsigned type;		/* protocol type code */
    short fill;
#else LITTLE_ENDIAN
    short unsigned nameindex;
    SystemCode	requestcode;
    short fill;
    short unsigned type;		/* protocol type code */
#endif LITTLE_ENDIAN
    unsigned 	unspecified[3];
    ContextId namecontextid;
    char *nameptr;
    unsigned namelength;
  } NQueryFileRequest;

typedef struct				/* NQuery IP File Reply */
  {
#ifndef LITTLE_ENDIAN
    SystemCode replycode;
    short protocoltype;			/* IPtype */
#else LITTLE_ENDIAN
    short protocoltype;			/* IPtype */
    SystemCode replycode;
#endif LITTLE_ENDIAN
    unsigned localIpAddr;		/* IP address in big-endian order */
    unsigned unspecified[6];
  } NQueryIpFileReply;

typedef struct				/* NQuery Pup File Reply */
  {
#ifndef LITTLE_ENDIAN
    SystemCode replycode;
    short protocoltype;			/* PUPtype */
    unsigned char localPupNet;
    unsigned char localPupHost;
    short fill;
#else LITTLE_ENDIAN
    short protocoltype;			/* PUPtype */
    SystemCode replycode;
    short fill;
    unsigned char localPupHost;
    unsigned char localPupNet;
#endif LITTLE_ENDIAN
    unsigned unspecified[6];
  } NQueryPupFileReply;

typedef struct				/*  Network Server Modify File */
  {					/* Request message format */
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    InstanceId 	fileid;
    unsigned short whichParm;		/* Indicates which parameter should
					   be modified. */
    short	fill;
#else LITTLE_ENDIAN
    InstanceId 	fileid;
    SystemCode	requestcode;
    short	fill;
    unsigned short whichParm;		/* Indicates which parameter should
					   be modified. */
#endif LITTLE_ENDIAN
    unsigned 	unspecified[6];
  } ModifyFileRequest;

typedef struct				/* Query file Request message */
  {					/* format.*/
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    InstanceId	fileid;
    unsigned short whichParms;		/* Indicates which parameters should
					   be returned. */
    short	fill;
#else LITTLE_ENDIAN
    InstanceId	fileid;
    SystemCode	requestcode;
    short	fill;
    unsigned short whichParms;		/* Indicates which parameters should
					   be returned. */
#endif LITTLE_ENDIAN
    unsigned	unspecified[6];
  } QueryFileRequest;


/* Parameter record formats for the various protocols
*/

typedef struct				/* IP protocol parameters */
  {
#ifndef LITTLE_ENDIAN
    char 	protocol;
    char	fill[3];
#else LITTLE_ENDIAN
    char	fill[3];
    char 	protocol;
#endif LITTLE_ENDIAN
  } IpParms;


typedef struct				/* TCP parameters set in the
					   CreateInstance call. */
  {
#ifndef LITTLE_ENDIAN
    short unsigned	localPort;
    short unsigned	foreignPort;
    long unsigned	foreignHost;
    unsigned short 	active;
    short 		security;
    short 		precedence;
    short 		fill;
#else LITTLE_ENDIAN
    short unsigned	foreignPort;
    short unsigned	localPort;
    long unsigned	foreignHost;
    short 		security;
    unsigned short 	active;
    short 		fill;
    short 		precedence;
#endif LITTLE_ENDIAN
  } TcpParms1;

typedef struct				/* TCP parameters which normally
					   receive default values, and also
					   various state information
					   parameters. */
  {
#ifndef LITTLE_ENDIAN
    short 		timeout;  /* Unit to use is clicks; i.e. .01 secs. */
    unsigned short	sndUrgFlag;
    unsigned short	rcvUrgFlag;
    short 		bytesAvail;
    short 		state;
    short		fill;
#else LITTLE_ENDIAN
    unsigned short	sndUrgFlag;
    short 		timeout;  /* Unit to use is clicks; i.e. .01 secs. */
    short 		bytesAvail;
    unsigned short	rcvUrgFlag;
    short		fill;
    short 		state;
#endif LITTLE_ENDIAN
  } TcpParms2;

typedef struct				/* PUP protocol parameters */
  {
    unsigned long socket;
  } PupParms;

#endif VNET
