/*
 * namecache.h
 *
 * Definitions for name caching, environment variables, etc.
 */

#ifndef _NAMECACHE
#define _NAMECACHE

#include "Venviron.h"

typedef struct _ENV
  {
    struct _ENV *next;		/* Must be first entry in struct */
    char *name;
    char *value;
  }
EnvironmentVariable;

typedef struct _NC
  {
    struct _NC *next;		/* Must be first entry in struct */
    char *name;
    unsigned short namelength;	/* for ease in sorting by name length */
    unsigned short flags;
    char *truename;		/* Absolute name saved for aliases */
    ContextPair from;		/* Name interpreted in this context...*/
    ContextPair to;		/*  ...leads to this context */
  }
NameCacheEntry;

/* Flags for cache entries */
#define DONT_FLUSH	1	/* This entry should never be flushed */
#define ALIAS	   	2	/* Alias; true absolute name in truename */
#define LOGICAL_PID	4	/* Temporary support for old servers */

#ifdef NAMING_STATS
typedef struct
  {
    unsigned long calls;	/* to NameSend */
    unsigned long tries;	/* tries - calls == retries */
    unsigned long relative;	/* relative names mapped (per call) */
    unsigned long lookups;	/* calls to NameCacheLookup from NameSend */
    unsigned long lookupSuccesses;
    unsigned long getPids;	/* calls to GetPid from NameSend */
    unsigned long partialHits;  /* cache hit, but still had to query (per try)*/
    unsigned long queries;	/* queries - partialHits == misses (per try) */
				/* tries - queries == hits (per try) */
    unsigned long queryFailures;
    unsigned long queryTimeouts;/* also included in queryFailures */
    unsigned long queryNoHelp;	/* no change in nameindex or context */
    unsigned long successes;	/* reply code to Send was OK */
				/* calls - successes = failures */
    unsigned long timeouts;	/* reply code to Send was KERNEL_TIMEOUT */
    unsigned long remapCurrCtx;	/* remapped current context name */
    unsigned long remapCurrCtxFail;
    unsigned long stale;	/* deletions of possibly stale cache entries */
    unsigned long remapAlias;	/* remapped an alias's true name */
    unsigned long remapAliasFail;
    unsigned long time;		/* clock time (clicks) when stats were zero */
  }
NamingStats;

#include <Venviron.h>
#include <Vgroupids.h>

#define ADD_STATS		(0x80+READ_BIT)
#define CLEAR_STATS		0x81
#define REPORT_STATS		0x82
#define REPORT_AND_CLEAR_STATS	0x83

#define NAMING_STATS_GROUP	VTEST_SERVER_GROUP
#define LNAMING_STATS_GROUP	LTEST_SERVER_GROUP

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode requestcode;
    unsigned short filler;
#else
    unsigned short filler;
    SystemCode requestcode;
#endif LITTLE_ENDIAN
    unsigned long time;
    unsigned long pid;
    unsigned long unspecified[3];
    NamingStats *statbuf;
    unsigned long bufsize;
  }
NamingStatsRequest;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode replycode;
    unsigned short filler;
#else
    unsigned short filler;
    SystemCode replycode;
#endif LITTLE_ENDIAN
    unsigned long unspecified[7];
  }
NamingStatsReply;

#endif NAMING_STATS

#endif _NAMECACHE
