/*
 * Distributed V Kernel
 * Copyright (c) 1986 by David Cheriton, Tim Mann
 *
 * Keyboard query and modify operations
 */

#ifndef VKEYBOARD
#define VKEYBOARD

/* Request message format */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode requestcode;	/* MODIFY_FILE */
    short fileid;
#else LITTLE_ENDIAN
    short fileid;
    SystemCode requestcode;	/* MODIFY_FILE */
#endif LITTLE_ENDIAN
    unsigned translation;
    unsigned padding[6];
  }    
ModifyKeyboardRequest;



typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode replycode;
    short padding1;
#else LITTLE_ENDIAN
    short padding1;
    SystemCode replycode;
#endif LITTLE_ENDIAN
    unsigned translation;
    unsigned padding2[6];
  }    
QueryKeyboardReply;

#define QueryKeyboardRequest IoRequest
#define ModifyKeyboardReply IoReply

#define TR_NONE		0
#define TR_ASCII	1

#endif VKEYBOARD
