/* Vinterface.h
 * 
 * Interface server constants, request codes, and message formats shared
 * between the Interface Server and clients.
 */

#ifndef VINTERFACE
#define VINTERFACE

#ifdef VAX_UNIX

#include <stdio.h>
#include <Vforunix.h>

#else  VAX_UNIX

#include <Vioprotocol.h>
#include <Vgroupids.h>

#endif VAX_UNIX

#include <modedata.h>
#include <standarddefs.h>

/* include if needed
 #include <minmax.h>
*/

/* 
 *  interface server mode bits, etc.
 */

#define NoCursor		0x0010
#define ReportClick 		0x0020
#define ReportTransition 	0x0040
#define ReportMotion 		0x0080
#define ReportChoice		0x0100
#define ReportTime		0x0200

#define MaxCoord 32767

#define	INTERFACE_SERVER	LINTERFACE_SERVER_GROUP

/* request codes */
#define CREATE_VIEW		0x1801
#define DELETE_VIEWS		0x0002
#define EDIT_LINE		0x1803
#define MODIFY_INPUT_STATE	0x1804
#define QUERY_INPUT_STATE	0x1405

#define is_BLOCKED		0x0006
#define is_DELETE_VIEW		0x0007


typedef struct
	/* Descriptor for a popup menu display entry. */
    {
    char *string;		/* String to display. */
    short menuNumber;	/* Number returned if entry selected. */
    } PopUpEntry;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    InstanceId			fileid;
    short			item;
    InstanceId			inputFile;
    short			sxmin, symin, sxmax, symax;
    short			wxmin, wymin;
    short			zoom;
    Boolean			showGrid;
    char			type;
#else  LITTLE_ENDIAN
    InstanceId			fileid;
    SystemCode			requestcode;
    InstanceId			inputFile;
    short			item;
    short			symin, sxmin, symax, sxmax;
    short			wymin, wxmin;
    char			type;
    Boolean			showGrid;
    short			zoom;
#endif LITTLE_ENDIAN
    char			*name;
    unsigned			length;
  } InterfaceViewReqMes;
 
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    InstanceId			fileid;
    short			item;
    short			fill0;
#else  LITTLE_ENDIAN
    InstanceId			fileid;
    SystemCode			requestcode;
    short			fill0;
    short			item;
#endif LITTLE_ENDIAN
    unsigned			operation;
    unsigned			actualSize;
    unsigned			fill[ 2 ];
    ModeDataType		*data;
    unsigned			dataSize;
  } InterfaceStateReqMes;


/* Note:  The input event protocol uses the following structures
 *
 * Ints are encoded as 4 bytes, in big-endian order
 * Shorts are encoded as 2 bytes, in big-endian order
 * Structures are packed, no padding is used
 * Events with a length field (e.g., StringEvent) are only as long
 *	as the length indicates
 */

/* Each event is preceded by this one-byte code, for synchronization */
#define EVENT_MAGIC	0x86

/* Input events, each a separate bit (for masks) */
/* Warning -- the last event 0x80000000 is reserved */
#define STRING_EVENT	0x00000001
#define CHOICE_EVENT	0x00000002
#define POINTER_EVENT	0x00000004
#define TIME_EVENT	0x00000008

#define EVENT_BUFFER_SIZE 1024

#define MAX_STRING_EVENT_LEN 512

typedef struct stringEvent
  {
    unsigned	length;
    char	string[MAX_STRING_EVENT_LEN];
  } StringEvent;

typedef struct choiceEvent
  {
    unsigned	choiceId;
    int		choice;
  } ChoiceEvent;

typedef struct pointerEvent
  {
    InstanceId	displayFileId;
    unsigned char	buttons;
    short	plane, x, y;
  } PointerEvent;

typedef struct timeEvent
  {
    unsigned	time;
  } TimeEvent;

typedef struct inputEvent
  {
    unsigned	kind;
    union
      {
        StringEvent	string;
	ChoiceEvent	choice;
	PointerEvent	pointer;
	TimeEvent	time;
      } u;
  } InputEvent;

#endif  VINTERFACE
