/* Format of font files and tables.
 * This file describes the sFont format, so-called because it is optimized
 * for Sun workstations, but inspired by Xerox Parc's Strike format.
 * Files with this format should have the extension .sf
 * Includable sf files have the extension .sfh
 *
 * Related files: text.h and gentext in libgraphics
 * Per Bothner. November 1982
 */

/* Table entry describing each character in the font; used below */
typedef struct
  {
    unsigned short word;	/* 2 * number of shorts from first word of font */
    unsigned char bit;		/* 0..15; bitnumber where bitmap starts. */
    unsigned char width;	/* width of char in pixels; default font is 8 */
  } CharInfo;

/* (Unimplemented)
 * Kerned fonts are such that the width of a character is unrelated to that
 * of its bounding box.
 * If kernTable is non-zero, it points to a table of kerning information.
 * Each KernInfo element is two bytes, whose meeaning hasn't been decided yet.
 */
typedef short KernInfo;

typedef struct 
  {
    unsigned short numBytes;	/* Total length of font, with header */
    /* note that measurements are in pixels */
    short height;		/* It is assumed that all characters in the font
				 * have the same height, though the width may vary
				 * (16 is common) */
    short maxWidth;		/* maximum width of characters in the font
				 * (For the common fixed-width fonts: 8) */
    short descent;		/* Descent of characters below the baseline.
				 * That is, character descend this far below
				 * the reference (starting) point. (Commonly 4) */
    unsigned char minChar, maxChar;
				/* First and last character (inclusive) in font.
				 * The WriteText routine assumes that
				 * minChar <= MINCHAR && maxChar >= MAXCHAR, where
				 * MINCHAR and MAXCHAR are defined in <text.h> */
    /* This next byte, if it is non-zero, indicates how to do under-lining.
     * We cannot just use the underline character, because of variable-width fonts.
     * The macro UnderLineCode (below) extracts this byte. */
    int underlineTop :5;	/* position of (top scanline of) underbar relative
	    			 * to baseline. If position==descent, top of
				 * underbar just overlaps bottom of char. */
    unsigned underlineThickness :3;  	/* thickness of underlineing */
    unsigned fixed :1;		/* 1 if each character is the same width */
    unsigned wordAligned :1;	/* 1 if each char aligned on a word boundary */
    unsigned byteAligned :1;	/* 1 if each char aligned on a byte boundary */
    unsigned indexable :1;	/* if all characters take the same space in the map */
    unsigned includeErrorChar :1;   /* 1 if there is a sprecial character to
				     * to indicate an illegal character.
				     * Its width is found after maxChar. */
    KernInfo *kernTable;	/* if non-zero, kernTable[Char] gives kerning info */
    /* then we have widths[minChar..maxChar] */
    CharInfo widths[1];	/*  */
    /* finally, the bit maps for the characters */
  } Sfont;
#define UnderlineCode(fontPtr) (((char *)fontPtr)[10])

#define SfontHeaderLen 8	/* (16 bit) words in font header */

/* A FontEntry is used in a FontTable, as described below.
 * It describes a font at a more user-oriented level
 */
typedef struct 
  {
    char *name;			/* String name of font */
    Sfont *font;			/* pointer to font itself */
    unsigned char number;	/* number of font */
    unsigned char italic;	/* number of italic/not-italic version of current font
				 * If zero, there is none.
				 * If this is an italic font, points to the
				 * corresponding roman font, whose number is LESS.
				 */
    unsigned char bold;		/* like italic, but for boldface */
    unsigned char filler[5];	/* to make this an even 16 bytes */
  } FontEntry;

/* These links are used if a program uses more than 16 fonts */
typedef struct _FontLink 
  {
    FontEntry fontEntry;
    struct _FontLink *next;
  } FontLink;

typedef struct
  {
    FontEntry first16[16];	/* first 16 fonts are statically allocated */
    FontLink *next;		/* list of fonts 17:255 */
  } FontTable;

extern FontTable Fonts;

#define NOFONT 0xFF	/* code for illegal/non-existant font */

/* codes returned by GetFontEntry if no font found: */
#define TooManyFonts	-1
#define FontFileNotFound -2
#define FontNotInFile -3	
#define BadFontFile -4		/* bad format of font file or archive */
#define NoFontMemory -5		/* malloc returned 0 */
