#include "nec7201.h"

/*  Address definitions for the nec7201 on the SUN board */

#define A_chan 	0
#define B_chan 	4

#define ContReg(ch)	*(char*)(0x600002+ch/**/_chan)
#define StatReg(ch)	*(char*)(0x600002+ch/**/_chan)	/* Read only */
#define TxHldReg(ch)	*(char*)(0x600000+ch/**/_chan)	/* Write only */
#define RxHldReg(ch)	*(char*)(0x600000+ch/**/_chan)	/* Read only */


/*  Programming the NEC PD7201 for the SUN M68000 board:  */
/*	Assumes External clock frequency 16 * baud rate */

/* Setting a control register */
#define NECset(ch,r,v) \
	ContReg(ch)= (char)r;\
	ContReg(ch)= (char)v

/* Reset Tx Interrupt */
#define UAtxres(ch)\
	ContReg(ch)= (char)NECtxres;\
	ContReg(ch)= (char)NECtxres

/* Reset External Latch */
#define NECresxt(ch)\
	ContReg(ch)= NECptres(0)

/* WRITE REGISTER 1 */
#define NECINR1		(NECtxint|NECrxina)

/* WRITE REGISTER 2 */
#define NECINR2		4	/* could also be zero, but remember clrb...*/	

/* WRITE REGISTER 3 */
#define NECINR3		(NECrxena|NECrx8bt|NECautoe)

/* WRITE REGISTER 4 */
#define NECINR4		(NECrx1sb|NEC16clk)

/* WRITE REGISTER 5 */
#define NECINR5		(NECtxrts|NECtxena|NECtx8bt|NECdtr)
#define	UAtxena(ch)	NECset(ch,5,NECINR5)
#define	UAtxdis(ch)	NECset(ch,5,(NECtxrts|NECtx8bt|NECdtr))

	
#define NECin(ch) \
{	register char *chadx;\
	chadx= &(ContReg(ch));\
	*chadx= (char)NECchres;\
	*chadx= (char)NECchres;\
	*chadx= (char)2;*chadx= (char)(NECINR2);\
	*chadx= (char)4;*chadx= (char)(NECINR4);\
	*chadx= (char)3;*chadx= (char)(NECINR3);\
	*chadx= (char)5;*chadx= (char)(NECINR5);\
	*chadx= (char)1;*chadx= (char)(NECINR1);\
}

#define initUART \
	TCSetGrp(TIMAClk,TMODuart,TFRQuart);\
	TCSetGrp(TIMBClk,TMODuart,TFRQuart);\
	TCArmCnt(TSCountA+TSCountB);\
	NECin(A);\
	NECin(B);\
	TxHldReg(B)= (char)'\0'

#define ReadUART(ch) RxHldReg(ch)

#define WriteUART(a,ch) TxHldReg(ch)= a

#define WriteBusy(a) \
		{while((char)(StatReg(A)&NECtxrdy)==0); TxHldReg(A)= a;}

#define UARTstat(ch) StatReg(ch)


