/*
 *  definitions for infoBase scanner/parsers
 *
 *  Cary Gray	March 1984
 *
 *  token definitions begin with t,
 *  attribute-parsing definitions with pa,
 *  structure-parsing with ps
 */


/* token-scanning decalrations */

#define ESCAPE_CHAR '@'
#define TOKEN_STRING_LENGTH NAME_STRING_LENGTH

#define NO_TOKEN_VALUE (-1)

extern int tLParens[];
extern int tRParens[];
#define BEGIN_END (-2)

extern int tSeparators[];
#define COLON_TOKEN (1)
#define EQUAL_TOKEN (2)

typedef enum {
    tNoToken,
    tEND,
    tCommand,
    tCommandChar,
    tLParen,
    tRParen,
    tSeparator,
    tNewLine,
    tWhitespace,
    tString
    } tTokenKindType;

typedef struct tTokenScannerRecord {
    char *scanFrom; /* pointer to file, object, etc., scanned */
    int  (* scanGetc)();
    long (* tellFunction)();
    tTokenKindType kind;
    int value;
    int ch;
    int lineNumber;
  } *tTokenScannerType;

/* imports */
extern tTokenKindType tNextToken();
extern tTokenScannerType tTokenStart();
extern tTokenEnd();
extern long tTokenTell();
extern long tDummyTell();
extern int  tWhichCharInTable();
extern tTokenKindType tKindOfChar();

/* attribute-parsing declarations */

typedef enum {
    paNormal,
    paWaitingOptionalArg,
    paWaitingLeftParen,
    paBeginWaitingLeftParen,
    paBeginName,
    paBeginWaitingRightParen,
    paEndWaitingLeftParen,
    paEndName,
    paEndWaitingRightParen,
    paError
  }  paParserStateType;

typedef enum {
    paBracket,
    paEnvironment,
    paNoArgCommand,
    paArgCommand,
    paOptArgCommand,
    paUnknownCommand
  }  paCommandKindType;


typedef enum {
    paRomanFont,
    paItalicFont,
    paBoldFont,
    paTypewriterFont,
    paProgramFont,
    paNoFont
  } paFontType;


typedef struct paCommandRecord {
    char *string;
    paCommandKindType kind;
    boolean paragraphEnvironment;
    paFontType font;
    boolean printEscape;
    boolean printCommand;
    boolean printArguments;
  } paCommandRecord;

extern paCommandRecord paCommands[];
#define BEGIN_COMMAND		&(paCommands[0])
#define END_COMMAND		&(paCommands[1])
#define R_ENVIRONMENT		&(paCommands[2])
#define I_ENVIRONMENT		&(paCommands[3])
#define B_ENVIRONMENT		&(paCommands[4])
#define T_ENVIRONMENT		&(paCommands[5])
#define TEXT_ENVIRONMENT	&(paCommands[6])
#define VERBATIM_ENVIRONMENT	&(paCommands[7])
#define ENUMERATE_ENVIRONMENT	&(paCommands[8])
#define DESCRIPTION_ENVIRONMENT	&(paCommands[9])
#define ITEMIZE_ENVIRONMENT	&(paCommands[10])
#define MULTIPLE_ENVIRONMENT	&(paCommands[11])
#define REF_COMMAND		&(paCommands[12])
#define PAGEREF_COMMAND		&(paCommands[13])
#define INDEX_COMMAND		&(paCommands[14])
#define AT_COMMAND		&(paCommands[15])
#define BACKSLASH_COMMAND	&(paCommands[16])
#define STAR_COMMAND		&(paCommands[17])
#define SPACE_COMMAND		&(paCommands[18])
#define UNRECOGNIZED_COMMAND	&(paCommands[19])


typedef struct paStackRecord {
    int  parenValue;
    char string[TOKEN_STRING_LENGTH];
    paCommandRecord *command;
    struct paStackRecord *next;
    } paStackRecord;

typedef enum { paInParagraph, paWaitingToStart, paWaitingToEnd } 
	ParagraphStateType;

typedef struct paParserRecord {
    paParserStateType parserState;
    boolean lineIsWhitespace;
    paStackRecord *commandStack;
    int expectedParen;
    paCommandRecord *holdCommand;
    char holdCommandString[TOKEN_STRING_LENGTH];
    ParagraphStateType paragraphState;
    int (* startArgument)();
    int (* endArgument)();
    int (* continueArgument)();
    int (* command)();
    int (* startParagraph)();
    int (* endParagraph)();
    int (* parseError)();
    } *paParserType;

/* parser functions */
extern paParserType paInitParser();
extern paEndParser();
extern paParseToken();

extern psScanStructure();
extern tTokenScannerType psTokenScanner;
