/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 *
 * Vkernel Ethernet manifests, structs, etc.
 *
 * NOTE: Little Endian machines must have special code for transforming
 *       network standard order into little endian word ordering. 
 */ 	 

#ifndef VETHERNET
#define VETHERNET

#include "Venviron.h"

/* The following are the defined sizes for 10 Mbit, and we use
 *   them for 3 Mbit too since there aren't well-defined standards.
 *   These give the number of bytes in the data portion of the packet,
 *   not including Ethernet header or CRC.
 */
#define ENET_MIN_DATA	46
#define ENET_MAX_DATA	1500

/* Address types */
typedef unsigned char Enet3Address;
typedef struct
  {
    unsigned short	addrhigh;
    unsigned short	addrmid;
    unsigned short	addrlow;
  } 
Enet10Address;

typedef union
  {
    Enet3Address 	e3;	
    Enet10Address 	e10;
    char		bytes[8]; /* fill out to two 32-bit words */
  }
EnetAddress;


/* Header definitions */
typedef struct 
  {
    Enet3Address	DestHost;	/* Id of destination host */
    Enet3Address	SrcHost;	/* Id of source host */
    unsigned short	EtherType;	/* EtherType of packet */
  }
Enet3Header;
#define ENET3_HEADER_SIZE	(sizeof( Enet3Header ))

typedef struct 
  {
    Enet10Address	DestHost;	/* Id of destination host */
    Enet10Address	SrcHost;	/* Id of source host */
    unsigned short	EtherType;	/* EtherType of packet */
  }

Enet10Header;
#define ENET10_HEADER_SIZE	(sizeof( Enet10Header ))


/* Packet structures */
typedef struct 
  {
    Enet3Address	DestHost;	/* Id of destination host */
    Enet3Address	SrcHost;	/* Id of source host */
    unsigned short	EtherType;	/* EtherType of packet */
    unsigned char	data[ENET_MAX_DATA];	/* actual data bytes */
  }
Enet3Packet;
#define ENET3_MAX_PACKET	(sizeof( Enet3Packet ) )

typedef struct 
  {
    Enet10Address	DestHost;	/* Id of destination host */
    Enet10Address	SrcHost;	/* Id of source host */
    unsigned short	EtherType;	/* EtherType of packet */
    unsigned char	data[ENET_MAX_DATA];	/* actual data bytes */
  }
Enet10Packet;
#define ENET10_MAX_PACKET	( sizeof( Enet10Packet ) )
#define ENET10_MIN_PACKET	( ENET10_HEADER_SIZE + ENET_MIN_DATA )


/* Receive Mask Bit Assignments */

#define ENET_SELF		1	/* Receive Packets for this host */
#define	ENET_BROADCAST		2	/* Receive broadcast packets */
#define ENET_PROMISCUOUS	4	/* Receive all packets */

#define ENET_DEFAULT_MASK	(ENET_SELF+ENET_BROADCAST)

#define ENET_TYPE_3MBIT		3
#define ENET_TYPE_10MBIT	10

/* Ethernet Query Reply Message Format. Request format uses the IoRequest
 * struct with only the request code (QUERY_FILE) and file instance fields
 * significant.
 */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		replycode;
    short		NetworkType;	/* ENET_TYPE_3MBIT or _10MBIT */
    short		NumCollisions;	
    short		NumOverflows;
    short		NumCRCErrors;
    short		NumSyncErrors;
    short		NumTimeOuts;
    short		ReceiveMask;
#else LITTLE_ENDIAN
    short		NetworkType;
    SystemCode		replycode;
    short		NumOverflows;
    short		NumCollisions;
    short		NumSyncErrors;
    short		NumCRCErrors;
    short		ReceiveMask;
    short		NumTimeOuts;
#endif LITTLE_ENDIAN
    int			NumValidPackets;
    EnetAddress		HostAddress;	/* conditioned on the NetworkType */  
    /*
     *  NOTE: LITTLE_ENDIAN machines must do the following for HostAddress:
     *	 	Enet3  - byte swap the first long word of this union 
     *		Enet10 - byte swap both long words of this union
     */
  } QueryEnetReply;


/* NetAddress and EnetBlock are for programs that can be
 *   compiled to use either 3Mbit or 10Mbit but not both.
 *   Should be eliminated eventually. */

#ifdef ENET3MEG
typedef Enet3Address NetAddress;
#else
typedef Enet10Address NetAddress;
#endif

typedef struct _EnetBlock	/* really an Ethernet packet */
  {
    NetAddress		DestHost;	/* Id of destination host */
    NetAddress		SrcHost;	/* Id of source host */
    unsigned short	EtherType;	/* EtherType of packet */
    unsigned char	data[ENET_MAX_DATA];	/* actual data bytes */
  }
EnetBlock;


#endif VETHERNET
