/* Given a Rectangle on the Qvss screen, generate a VRaster descriptor */
#include <Vfont.h>
extern VRaster QvssFb;

VRaster *
QvssRectangle(raster, rect)
    register VRaster *raster;	/* out: subraster of WholeScreen */
    register Rectangle *rect;	/* in: part of he framebuffer */
  {
    raster[-1].bBox = rect->size;
    raster[-1].xoffset = rect->start.h;
    raster[-1].stride = 128;
    Options(raster[-1]) = RasterInverse;
    raster[-1].start = QvssFb.start
	+ BitAlign * (rect->start.h >> BitWordLog) + 128 * rect->start.v;
    return raster;
  }
