/* A raster, stored in the framebuffer. */
typedef struct
  {
    short	height;
    short	width;
    short	x;		/* x coordinate of upper left corner. */
    short	y;		/* y coordinate of upper left corner. */
  }
fb_raster;

/* A raster, stored in main memory.
 * Note: this format sucks, and should be changed eventually. */
typedef struct
  {
    short	height;
    short	width;
    short	*start;		/* start address of the raster in memory. */
  }
mem_raster;

/* A 16-bit entry in the framebuffer. */
typedef unsigned short fbWord;

/* The address of a framebuffer entry. */
typedef unsigned char *fbAddress; /* Must always be even. */

typedef fbWord *patPtr;	/* (pointer to) an array of 16 shorts. */
typedef fbWord patArray[16]; /* Such an array allocated explicitly. */

/* Global variables, to be set by the application on initialization. */
extern int GXBase;				/* framebuffer base address. */
extern short ScreenLimitX, ScreenLimitY;	/* framebuffer limits */

/* Framebuffer base addresses for Sun-2 upgrades and Sun-2s. */
#define SUN2upgFbBase 0xFC0000/* Address of Sun-1 framebuffer in Sun-2(upg). */
#define SUN2FbBase 0xEC0000 /* Address of Sun-2 framebuffer in Sun-2 (proper).*/

/* A 'multiplication' macro, optimizing for the expected case where the
 * multiplier is 144 (the usual width of the screen in bytes).  This avoids
 * having to call "lmul".  (Yes, I know this is disgusting.)
 */
#define mult(x,y) ((y == 144) ? ((x)<<4) + ((x)<<7) : (x)*(y))
