/*
 *		Sun-2 graphics library.
 *		Ross Finlayson, August 1984.
 */

/* Simple text output routines. */

/* Exports:	Sun2_DrawSimpleText(). */

#include "sun2framebuffer.h"

/*
 * "WideStandardFont" is the address of an array containing a special
 * fixed-width font. This font is the same font that is used in the
 * corresponding Sun-1 graphics routine, and is defined in
 * /xV/libc/graphics/m68k/widestdfont.c.
 * Each character is 16 pixels high and 8 pixels wide.
 *
 * In fact, "WideStandardFont" points to a 256x16 array of shorts.  Thus, each
 * character is a sequence of 16 shorts.  Only the high-order byte of each such
 * short is significant - the low-order byte is zero.
 *
 * Similarly, "StandardFont" points to a copy of the same array, except that
 * the elements are bytes - namely, the high-order bytes of the
 * "WideStandardFont" array.
 * This array is defined in /xV/libc/graphics/m68k/stdfont.c.
 *
 * As with the Sun-1 routine, this routine is dependent on (and optimized for)
 * each character's raster being 8 pixels wide. 
 */ 
extern short WideStandardFont[];
extern char StandardFont[];

/* these are actually asm-visible statics */
asm("ShortFontTop: .long 0");
asm("CharFontTop: .long 0");
extern short *ShortFontTop;
extern char *CharFontTop;

#define FontHeight 16
#define FontWidth 8

extern d0;
extern char *a0;

#define setmin(x,y) if (y < x) x = y
#define setmax(x,y) if (y > x) x = y

/* The following macro efficiently computes the position, in the font
 * array, of the bitmap for the next character, placing the result in d0.
 * This code is equivalent to:
 * 	d0 = ShortFontTop + (((*string++) & 0xFF) << 5);
 */
#define GetShortBitmap\
    a0 = string;\
    ++string;\
    asm("moveq #0,d0");\
    asm("movb a0@,d0");\
    asm("aslw #5,d0");\
    asm("addl ShortFontTop,d0")
/* The following macro does a similar thing, using "CharFontTop":
    d0 = CharFontTop + (((*string++) & 0xFF) << 4); */	
#define GetCharBitmap\
    a0 = string;\
    ++string;\
    asm("moveq #0,d0");\
    asm("movb a0@,d0");\
    asm("aslw #4,d0");\
    asm("addl CharFontTop,d0")


Sun2_DrawSimpleText( left, bottom, string, length, paintFlag,
		     clipLeft, clipRight, clipTop, clipBottom )
   int left, bottom, clipLeft, clipRight, clipTop, clipBottom;
   char *string;
   int length;
   int paintFlag;	/* true means paint ("or") instead of draw ("store"). */
   /* Prints at most "length" characters of "string" in the place specified by
    * "left" and "bottom", clipped at the lines given by "clipTop",
    * "clipBottom", "clipLeft" and "clipRight".
    * NOTE: printing takes place ON these clipping lines.
    */
  {
    register fbAddress fbyAddr;				/* a5 */
    register fbWord *font1Ptr, *arrayPtr;		/* a4, a3 */
    register unsigned char *font2Ptr;			/* a2 */

    register fbWord save1, save2, mask;			/* d7, d6, d5 */
    register count, offset, screenWidth;		/* d4, d3, d2 */

    fbAddress fbxAddr, firstCol, lastCol;
    int clipHeight, right, top, leftOffset, rightOffset,
        oddLength;
    fbWord leftMask, rightMask;
    fbWord leftPartArray[16], /* Temporary storage for the overflows. */
	   lastColSave[16];
    
    if ( length <= 0 )
	return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */

    top = bottom - 15;
    right = left + (length<<3) - 1;
    /* Make sure we have something to print. */
    if ( (clipLeft > clipRight) || (clipTop > clipBottom) ||
	 (bottom < clipTop) || (clipBottom < top) ||
	 (left > clipRight) || (clipLeft > right) )
        return;

    /* Recompute the clipping boundaries. */
    setmin(clipBottom, bottom);
    setmax(clipTop, top);
    setmax(clipLeft, left);
    setmin(clipRight, right);

    /* Compute the destination framebuffer address of the top left corner: */
    fbyAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    fbyAddr += mult(clipTop, screenWidth);	/* + rows above */
    firstCol = fbyAddr + ((clipLeft>>3) & ~1);	/* + space to the left */
    /* ...and of the last column. */
    lastCol = fbyAddr + ((clipRight>>3) & ~1);
    fbxAddr = fbyAddr = firstCol;

    ShortFontTop = WideStandardFont + clipTop - top;
    CharFontTop = StandardFont + clipTop - top;
    clipHeight = clipBottom - clipTop;

    leftOffset = clipLeft & 15;
    leftMask = 0xFFFF0000>>leftOffset;	/* e.g. 1110000000000000 */
    rightOffset = (clipRight + 1) & 15;
    rightMask = 0xFFFF>>rightOffset;	/* e.g. 0000011111111111 */

    /* Find the first character to print, and how many to print. */
    if (clipLeft > left)
      {
	left -= clipLeft;
	while ((left += 8) <= 0)
	    ++string;
	left += clipLeft - 8;
	offset = left & 15; /* left%16 */
      }
    else
        offset = leftOffset;
    length = ((clipRight - left)>>3) + 1;
    if (offset >= 8)
        --length; /* we handle the first character separately in this case. */
    oddLength = (length & 1); /* is there a char left over at the end? */
    length >>= 1; /* since we draw characters in pairs. */

    /* Note: "offset" is the offset of the first printed character from a
     * 16-bit boundary.  "leftOffset" and "rightOffset" are the offsets of the
     * left and right clipping lines.  Thus, usually "leftOffset" = "offset".
     */

    /* In one uncommon situation, we need to save away the current contents of
     * the last column, to be (partially) restored later.
     */
    if ( (rightOffset > 8) && !oddLength )
      {
	arrayPtr = lastColSave;
	fbyAddr = lastCol;
	count = clipHeight;
	asm("lastCol_saveloop:");		/* do */
	    *arrayPtr++ = *(fbWord *)fbyAddr;
	    fbyAddr += screenWidth;
	asm("dbf d4,lastCol_saveloop");		/* while (--count >= 0); */
        fbyAddr = firstCol;
      }

    /* If we are 'painting' instead of 'drawing', branch to special code: */
    if (paintFlag)
        goto paintCode;

/************************** Drawing *****************************************/  
    /* We handle several cases separately, depending upon "offset": */
    if (offset & 7)
	/* The difficult cases: 0<offset<8 or 8<offset<16 */
      {
	/* Fill in the elements of "leftPartArray" for the initial iteration. */
	arrayPtr = leftPartArray;
	count = clipHeight;
	if (offset < 8)
	  {
	    mask = 0xFFFF0000>>offset;	/* e.g. 1100000000000000 */
	    if (leftOffset == offset) /* the usual case */
	      {
		asm("draw_first7loop1:");	/* do */
		    save1 = *(fbWord *)fbyAddr;
		    save1 &= mask;
		    *arrayPtr++ = save1;
		    fbyAddr += screenWidth;
	        asm("dbf d4,draw_first7loop1");	/* while (--count >= 0); */
	      }
	    else
	      { /* an uncommon case - we must peek ahead at the first char. */
	        GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
		asm("draw_first7loop2:");	/* do */
		    save1 = *font1Ptr++;
		    save1 >>= offset;
		    save1 ^= *(fbWord *)fbyAddr;
		    save1 &= leftMask;
		    *arrayPtr++ = save1;
		    fbyAddr += screenWidth;
	        asm("dbf d4,draw_first7loop2");	/* while (--count >= 0); */
		--string; /* since we will look at the first character again. */
	      }
	  }
	else /* 8 < offset < 16 */
	  {
	    offset -= 8;
	    mask = 0xFFFF0000>>offset;
	    /* As well, perform a special loop for the first character: */
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    if (leftOffset < 8)
	      { /* don't print the first char - just shift into the array. */
		asm("draw_first15loop1:");	/* do */
		    asm("movb a2@+,d7"); /* save1 = *font2Ptr++; */
		    /* rotate "save1" right by "offset": */
		    asm("rorw d3,d7");
		    save2 = *(fbWord *)fbyAddr;
		    save2 ^= save1;
		    save2 &= leftMask;
		    save2 ^= save1;
		    save2 &= mask;
		    *arrayPtr++ = save2;
		    fbyAddr += screenWidth;
		asm("dbf d4,draw_first15loop1");/* while (--count >= 0); */
	      }
	    else /* leftOffset > 8, the usual case */
	      { /* print the first character, as well as filling in the array */
		leftOffset -= 8;
		asm("draw_first15loop2:");	/* do */
		    asm("movb a2@+,d7"); 	/* save1 = *font2Ptr++; */
		    save1 &= 0xFF;
		    /* rotate "save1" right by "offset": */
		    asm("rorw d3,d7");
		    save2 = *(fbWord *)fbyAddr;
		    save2 ^= save1;
		    save2 &= leftMask;
		    save2 ^= save1;
		    save1 &= mask;
		    *arrayPtr++ = save1;
		    *(fbWord *)fbyAddr = save2;
		    fbyAddr += screenWidth;
		asm("dbf d4,draw_first15loop2");/* while (--count >= 0); */
		fbxAddr += 2;
	      }
	  }
	    
	/* The main loop: */
	/* Draw the framebuffer raster, pairs of characters at a time. */
	/* We split the main loop up into 2 cases, namely: 0 < offset <= 4, and
	 * 4 < offset < 8.  We do this so that we don't have to rotate more than
	 * 4 bit positions.  This can save up to 20ms when printing a
	 * 24x80 pad.
	 */
	if (offset <= 4)
	 while (--length >= 0)
	  {
	    fbyAddr = fbxAddr;
	    fbxAddr += 2;
	    arrayPtr = leftPartArray;
		
	    /* Draw each of the 16 rows of the next 2 characters. */
	    count = clipHeight;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    asm("draw_mainloop:");		/* do */
		save1 = *font1Ptr++;
		asm("orb a2@+,d7"); /* save1 |= *font2Ptr++; */
		/* rotate "save1" right by "offset": */
		asm("rorw d3,d7");
		save2 = *arrayPtr;
		save2 ^= save1;
		save1 &= mask;
		save2 ^= save1;
		*arrayPtr++ = save1;
		*(fbWord *)fbyAddr = save2;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_mainloop");	/* while (--count >= 0); */
	  }
	else /* 4 < offset < 8 */
	 {offset = 8 - offset;
	  while (--length >= 0)
	  {
	    fbyAddr = fbxAddr;
	    fbxAddr += 2;
	    arrayPtr = leftPartArray;
		
	    /* Draw each of the 16 rows of the next 2 characters. */
	    count = clipHeight;
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    asm("draw_main2loop:");		/* do */
		save1 = *font1Ptr++;
		asm("orb a2@+,d7"); /* save1 |= *font2Ptr++; */
		/* rotate "save1" left by "offset": */
		asm("rolw d3,d7");
		save2 = *arrayPtr;
		save2 ^= save1;
		save1 &= mask;
		save2 ^= save1;
		*arrayPtr++ = save1;
		*(fbWord *)fbyAddr = save2;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_main2loop");	/* while (--count >= 0); */
	  }
	 offset = 8 - offset;}
	      
	/* Now print (or finish printing) the right-hand column: */
	mask = rightMask;
	count = clipHeight;
	if (oddLength)
	  {
	    /* Print the leftover character. */
	    arrayPtr = leftPartArray;
	    fbyAddr = fbxAddr;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    asm("draw_oddloop:");		/* do */
		save1 = *font1Ptr++;
		save1 >>= offset;
		save1 ^= *arrayPtr++;
		save2 = *(fbWord *)fbyAddr;
		save2 ^= save1;
		save2 &= mask;
		save1 ^= save2;
		*(fbWord *)fbyAddr = save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_oddloop");	/* while (--count >= 0); */
	  }
	else if (rightOffset > 8)
	  {
	    /* restore the part of the framebuffer that we saved away earlier */
	    arrayPtr = lastColSave;
	    fbyAddr = lastCol;
	    asm("draw_lastCol_fixloop:");		/* do */
		save1 = *(fbWord *)fbyAddr;
		save1 ^= *arrayPtr++;
		save1 &= mask;
		*(fbWord *)fbyAddr ^= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_lastCol_fixloop");	/* while (--count >= 0); */
	  }
	else if (rightOffset > 0)
	  {
	    /* Print what was left of the previous character. */
	    arrayPtr = leftPartArray;
	    fbyAddr = fbxAddr;
	    asm("draw_evenloop:");		/* do */
		save1 = *arrayPtr++;
		save2 = *(fbWord *)fbyAddr;
		save2 ^= save1;
		save2 &= mask;
		save1 ^= save2;
		*(fbWord *)fbyAddr = save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_evenloop");	/* while (--count >= 0); */
	  }
      }

    else

	/* The easiest cases: offset == 0 or 8 */
      {
	if (offset == 8)
	  {
	    /* Perform a special loop, printing the first character: */
	    mask = leftMask;
	    count = clipHeight;
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    asm("draw_first8loop:");	/* do */
		asm("movb a2@+,d7"); /* save1 = *font2Ptr++; */
		save2 = *(fbWord *)fbyAddr;
		save2 ^= save1;
		save2 &= mask;
		save2 ^= save1;
		*(fbWord *)fbyAddr = save2;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_first8loop");	/* while (--count >= 0); */
	    fbxAddr += 2;
	  }
	else if (leftOffset > 0)
	  { /* an uncommon (and messy) case - print the first characters
	       separately. */
	    mask = leftMask;
	    count = clipHeight;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    if (--length >= 0)
	      { /* print the first two characters: */
		GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
		asm("draw_first0loop1:");	/* do */
		    save1 = *font1Ptr++;
		    asm("movb a2@+,d6"); /* save2 = *font2Ptr++; */
		    asm("orb d6,d7"); /* save1 |= save2; */
		    save2 = *(fbWord *)fbyAddr;
		    save2 ^= save1;
		    save2 &= mask;
		    save1 ^= save2;
		    *(fbWord *)fbyAddr = save1;
		    fbyAddr += screenWidth;
		asm("dbf d4,draw_first0loop1");	/* while (--count >= 0); */
		fbxAddr += 2;
	      }
	    else
	      { /* print the first (and only) character */
		mask |= rightMask;
		asm("draw_first0loop2:");	/* do */
		    save1 = *font1Ptr++;
		    save2 = *(fbWord *)fbyAddr;
		    save2 ^= save1;
		    save2 &= mask;
		    save1 ^= save2;
		    *(fbWord *)fbyAddr = save1;
		    fbyAddr += screenWidth;
		asm("dbf d4,draw_first0loop2");	/* while (--count >= 0); */
		oddLength = 0; /* so we don't print this character again. */
	      }
	  }


	/* The main loop: */
	/* Draw the framebuffer raster, pairs of characters at a time. */
	while (--length >= 0)
	  {
	    fbyAddr = fbxAddr;
	    fbxAddr += 2;
		
	    /* Draw each of the 16 rows of the next 2 characters. */
	    count = clipHeight;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    asm("draw_main0loop:");	/* do */
		save1 = *font1Ptr++;
		asm("orb a2@+,d7"); /* save1 |= *font2Ptr++; */
		*(fbWord *)fbyAddr = save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_main0loop");/* while (--count >= 0); */
	  }

	/* Now print (or finish printing) the right-hand column: */
	mask = rightMask;
	count = clipHeight;
	if (oddLength)
	  {
	    /* Print the leftover character. */
	    fbyAddr = fbxAddr;
	    count = clipHeight;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    asm("draw_odd0loop:");		/* do */
		save1 = *font1Ptr++;
		save2 = *(fbWord *)fbyAddr;
		save2 ^= save1;
		save2 &= mask;
		save1 ^= save2;
		*(fbWord *)fbyAddr = save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_odd0loop");	/* while (--count >= 0); */
	  }
	else if (rightOffset > 8)
	  {
	    /* restore the part of the framebuffer that we saved away earlier */
	    arrayPtr = lastColSave;
	    fbyAddr = lastCol;
	    asm("draw_lastCol_fixloop0:");	/* do */
		save1 = *(fbWord *)fbyAddr;
		save1 ^= *arrayPtr++;
		save1 &= mask;
		*(fbWord *)fbyAddr ^= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,draw_lastCol_fixloop0");/* while (--count >= 0); */
	  }
      }
    return;

/************************** Painting ****************************************/  
/* NOTE: painting of inverted characters still paints black on white. */
paintCode:
/*
 * This code is similar to that above, the main difference being that
 * assignments to the framebuffer are replaced with 'or's into the framebuffer.
 * Some of the initial and final loops are simpler than those of the "drawing"
 * code.  The modified loops are marked with a "***".
 */

    /* We handle several cases separately, depending upon "offset": */
    if (offset & 7)
	/* The difficult cases: 0<offset<8 or 8<offset<16 */
      {
	/* Fill in the elements of "leftPartArray" for the initial iteration. */
	arrayPtr = leftPartArray;
	count = clipHeight;
	if (offset < 8)
	  {
	    mask = 0xFFFF0000>>offset;	/* e.g. 1100000000000000 */
	    if (leftOffset == offset) /* the usual case */
	      { /***/
		asm("paint_first7loop1:");	/* do */
		    *arrayPtr++ = 0;
	        asm("dbf d4,paint_first7loop1");/* while (--count >= 0); */
	      }
	    else
	      { /***/
	        /* an uncommon case - we must peek ahead at the first char. */
	        GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
		asm("paint_first7loop2:");	 /* do */
		    save1 = *font1Ptr++;
		    save1 >>= offset;
		    save1 &= leftMask;
		    *arrayPtr++ = save1;
	        asm("dbf d4,paint_first7loop2"); /* while (--count >= 0); */
		--string; /* since we will look at the first character again. */
	      }
	  }
	else /* 8 < offset < 16 */
	  { /***/
	    offset -= 8;
	    mask = 0xFFFF0000>>offset;
	    leftMask = ~leftMask;
	    /* As well, perform a special loop for the first character: */
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    if (leftOffset < 8)
	      { /* don't print the first char - just shift into the array. */
		asm("paint_first15loop1:");	/* do */
		    asm("movb a2@+,d7"); /* save1 = *font2Ptr++; */
		    /* rotate "save1" right by "offset": */
		    asm("rorw d3,d7");
		    save1 &= mask;
		    save1 &= leftMask;
		    *arrayPtr++ = save1;
		asm("dbf d4,paint_first15loop1");/* while (--count >= 0); */
	      }
	    else /* leftOffset > 8, the usual case */
	      { /* print the first character, as well as filling in the array */
		leftOffset -= 8;
		asm("paint_first15loop2:");	/* do */
		    asm("movb a2@+,d7"); /* save1 = *font2Ptr++; */
		    /* rotate "save1" right by "offset": */
		    asm("rorw d3,d7");
		    save2 = save1;
		    save1 &= mask;
		    *arrayPtr++ = save1;
		    save2 &= leftMask;
		    *(fbWord *)fbyAddr |= save2;
		    fbyAddr += screenWidth;
		asm("dbf d4,paint_first15loop2");/* while (--count >= 0); */
		fbxAddr += 2;
	      }
	  }
	    
	/* The main loop: */
	/* Draw the framebuffer raster, pairs of characters at a time. */
	/* We split the main loop up into 2 cases, namely: 0 < offset <= 4, and
	 * 4 < offset < 8.  We do this so that we don't have to rotate more than
	 * 4 bit positions.  This can save up to 20ms when printing a
	 * 24x80 pad.
	 */
	if (offset <= 4)
	 while (--length >= 0)
	  {
	    fbyAddr = fbxAddr;
	    fbxAddr += 2;
	    arrayPtr = leftPartArray;
		
	    /* Draw each of the 16 rows of the next 2 characters. */
	    count = clipHeight;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    asm("paint_mainloop:");		/* do */
		save1 = *font1Ptr++;
		asm("orb a2@+,d7"); /* save1 |= *font2Ptr++; */
		/* rotate "save1" right by "offset": */
		asm("rorw d3,d7");
		save2 = *arrayPtr;
		save2 ^= save1;
		save1 &= mask;
		save2 ^= save1;
		*arrayPtr++ = save1;
		*(fbWord *)fbyAddr |= save2;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_mainloop");	/* while (--count >= 0); */
	  }
	else /* 4 < offset < 8 */
	 {offset = 8 - offset;
	  while (--length >= 0)
	  {
	    fbyAddr = fbxAddr;
	    fbxAddr += 2;
	    arrayPtr = leftPartArray;
		
	    /* Draw each of the 16 rows of the next 2 characters. */
	    count = clipHeight;
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    asm("paint_main2loop:");		/* do */
		save1 = *font1Ptr++;
		asm("orb a2@+,d7"); /* save1 |= *font2Ptr++; */
		/* rotate "save1" left by "offset": */
		asm("rolw d3,d7");
		save2 = *arrayPtr;
		save2 ^= save1;
		save1 &= mask;
		save2 ^= save1;
		*arrayPtr++ = save1;
		*(fbWord *)fbyAddr |= save2;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_main2loop");	/* while (--count >= 0); */
	  }
	 offset = 8 - offset;}
	      
	/* Now print (or finish printing) the right-hand column: */
	mask = rightMask;
	count = clipHeight;
	if (oddLength)
	  { /***/
	    /* Print the leftover character. */
	    mask = ~mask;
	    arrayPtr = leftPartArray;
	    fbyAddr = fbxAddr;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    asm("paint_oddloop:");		/* do */
		save1 = *font1Ptr++;
		save1 >>= offset;
		save1 ^= *arrayPtr++;
		save1 &= mask;
		*(fbWord *)fbyAddr |= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_oddloop");	/* while (--count >= 0); */
	  }
	else if (rightOffset > 8)
	  {
	    /* restore the part of the framebuffer that we saved away earlier */
	    arrayPtr = lastColSave;
	    fbyAddr = lastCol;
	    asm("paint_lastCol_fixloop:");	/* do */
		save1 = *(fbWord *)fbyAddr;
		save1 ^= *arrayPtr++;
		save1 &= mask;
		*(fbWord *)fbyAddr ^= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_lastCol_fixloop");/* while (--count >= 0); */
	  }
	else if (rightOffset > 0)
	  { /***/
	    /* Print what was left of the previous character. */
	    mask = ~mask;
	    arrayPtr = leftPartArray;
	    fbyAddr = fbxAddr;
	    asm("paint_evenloop:");		/* do */
		save1 = *arrayPtr++;
		save1 &= mask;
		*(fbWord *)fbyAddr |= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_evenloop");	/* while (--count >= 0); */
	  }
      }

    else

	/* The easiest cases: offset == 0 or 8 */
      {
	if (offset == 8)
	  { /***/
	    /* Perform a special loop, printing the first character: */
	    mask = ~leftMask;
	    count = clipHeight;
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    asm("paint_first8loop:");	/* do */
		asm("movb a2@+,d7"); /* save1 = *font2Ptr++; */
		save1 &= mask;
		*(fbWord *)fbyAddr |= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_first8loop");	/* while (--count >= 0); */
	    fbxAddr += 2;
	  }
	else if (leftOffset > 0)
	  { /***/
	    /* an uncommon (and messy) case - print the first characters
	       separately. */
	    mask = ~leftMask;
	    count = clipHeight;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    if (--length >= 0)
	      { /* print the first two characters: */
		GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
		asm("paint_first0loop1:"); 	 /* do */
		    save1 = *font1Ptr++;
		    asm("movb a2@+,d6"); /* save2 = *font2Ptr++; */
		    asm("orb d6,d7"); /* save1 |= save2; */
		    save1 &= mask;
		    *(fbWord *)fbyAddr |= save1;
		    fbyAddr += screenWidth;
		asm("dbf d4,paint_first0loop1"); /* while (--count >= 0); */
		fbxAddr += 2;
	      }
	    else
	      { /* print the first (and only) character */
		mask &= ~rightMask;
		asm("paint_first0loop2:");	 /* do */
		    save1 = *font1Ptr++;
		    save1 &= mask;
		    *(fbWord *)fbyAddr |= save1;
		    fbyAddr += screenWidth;
		asm("dbf d4,paint_first0loop2"); /* while (--count >= 0); */
		oddLength = 0; /* so we don't print this character again. */
	      }
	  }


	/* The main loop: */
	/* Draw the framebuffer raster, pairs of characters at a time. */
	while (--length >= 0)
	  {
	    fbyAddr = fbxAddr;
	    fbxAddr += 2;
		
	    /* Draw each of the 16 rows of the next 2 characters. */
	    count = clipHeight;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    GetCharBitmap; asm("movl d0,a2"); /* font2Ptr = d0; */
	    asm("paint_main0loop:");	/* do */
		save1 = *font1Ptr++;
		asm("orb a2@+,d7"); /* save1 |= *font2Ptr++; */
		*(fbWord *)fbyAddr |= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_main0loop");/* while (--count >= 0); */
	  }

	/* Now print (or finish printing) the right-hand column: */
	mask = rightMask;
	count = clipHeight;
	if (oddLength)
	  { /***/
	    /* Print the leftover character. */
	    mask = ~mask;
	    fbyAddr = fbxAddr;
	    count = clipHeight;
	    GetShortBitmap; asm("movl d0,a4"); /* font1Ptr = d0; */
	    asm("paint_odd0loop:");		/* do */
		save1 = *font1Ptr++;
		save1 &= mask;
		*(fbWord *)fbyAddr |= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_odd0loop");	/* while (--count >= 0); */
	  }
	else if (rightOffset > 8)
	  {
	    /* restore the part of the framebuffer that we saved away earlier */
	    arrayPtr = lastColSave;
	    fbyAddr = lastCol;
	    asm("paint_lastCol_fixloop0:");	/* do */
		save1 = *(fbWord *)fbyAddr;
		save1 ^= *arrayPtr++;
		save1 &= mask;
		*(fbWord *)fbyAddr ^= save1;
		fbyAddr += screenWidth;
	    asm("dbf d4,paint_lastCol_fixloop0");/* while (--count >= 0); */
	  }
      }
/****************************************************************************/  

  }
