/*
 *		Sun-2 graphics library.
 *		Ross Finlayson, June 1984.
 */

/* Operations for drawing copies of 16x16 patterns stored in main memory.
 * Patterns are stored as 16 16-bit words, representing a 16-bit wide column.
 */
/* Exports:	Sun2_PutPattern(), Sun2_PaintPattern(). */

#include "sun2framebuffer.h"


Sun2_PutPattern(dst, p)
    fb_raster *dst;
    patPtr p;
    /* Fills the area "dst" with the pattern "p". */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register fbWord leftMask, rightMask;	/* d7, d6 */
    register screenWidth, height, width, count;	/* d5, d4, d3, d2 */
    register patPtr pat1, pat2;			/* a3, a2 */

    fbAddress xEndAddr;
    unsigned short leftOffset, rightOffset;
    patArray maskedPat; /* Storage for masked copies of "p". */
    unsigned short yOffset;
    
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    xEndAddr = xAddr + ((width>>3) & ~1);
    rightOffset = width & 15;

    leftMask = 0xFFFF>>leftOffset;		/* e.g. 001111111111111 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Note that we must also correctly align the pattern vertically. */
    yOffset = (dst->y) & 15;

    /* Handle the special case of a single 'column' */
    if (width < 16)
      {
        leftMask &= rightMask;
	++leftOffset;
	rightOffset = 0;
      }

    /* Draw the left offset column: */
    --height;
    if (leftOffset > 0)
      {
	/* Make a masked copy of "p" in "maskedPat". */
	pat1 = p;
	pat2 = maskedPat;
	for (count = 0; count < 16; ++count)
	    *pat2++ = *pat1++ & leftMask;

	/* Now fill in the left column. */
	pat1 = maskedPat + yOffset;
	pat2 = maskedPat + 16;
	leftMask = ~leftMask;
	count = height;
	yAddr = xAddr;

        asm("put_leftloop:");			/* do */
	    *(fbWord *)yAddr &= leftMask; /* off with the old bits... */
	    *(fbWord *)yAddr |= *pat1++; /* ...and in with the new. */
	    yAddr += screenWidth;
	    /* Reset "pat1" on every 16th iteration. */
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne putpatll");
	    asm("lea a6@(-/28),a3"); /* pat1 = maskedPat; */
        asm("putpatll: dbf d2,put_leftloop");   /* while (--count >= 0); */

	xAddr += 2;
      }

    /* Draw the right offset column, in the same way. */
    if (rightOffset > 0)
      {
	pat1 = p;
	pat2 = maskedPat;
	for (count = 0; count < 16; ++count)
	    *pat2++ = *pat1++ & rightMask;

	pat1 = maskedPat + yOffset;
	pat2 = maskedPat + 16;
	rightMask = ~rightMask;
	count = height;
	yAddr = xEndAddr;

        asm("put_rightloop:");		/* do */
	    *(fbWord *)yAddr &= rightMask;
	    *(fbWord *)yAddr |= *pat1++;
	    yAddr += screenWidth;
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne putpatrl");
	    asm("lea a6@(-/28),a3"); /* pat1 = maskedPat; */
        asm("putpatrl: dbf d2,put_rightloop");  /* while (--count >= 0); */

      }

    /* Draw the midsection, row by row. */
    width = (xEndAddr - xAddr)>>1;
    if (width-- > 0)
      {
	pat1 = p + yOffset;
	pat2 = p + 16;
	yAddr = xEndAddr;

        asm("put_midouterloop:");		/* do */
	  {
	    count = width;
	    xAddr = yAddr;
	    leftMask = *pat1++;

            asm("put_midinnerloop:");		/* do */
	    asm("movw d7,a5@-");		/* *(xAddr -= 2) = leftMask; */
            asm("dbf d2,put_midinnerloop");	/* while (--count >= 0); */

	    yAddr += screenWidth;
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne putpatmol");
	    asm("movl a6@(/C),a3"); /* pat1 = p; */
	  }
        asm("putpatmol: dbf d4,put_midouterloop");/* while (--height >= 0); */

      }
  }



Sun2_PaintPattern(dst, p)
    fb_raster *dst;
    patPtr p;
    /* 'Paints' (black on white) the pattern "p" onto the area "dst".
     * That is, "p" is or'd onto "dst".
     */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register fbWord leftMask, rightMask;	/* d7, d6 */
    register screenWidth, height, width, count;	/* d5, d4, d3, d2 */
    register patPtr pat1, pat2;			/* a3, a2 */

    fbAddress xEndAddr;
    unsigned short leftOffset, rightOffset;
    patArray maskedPat; /* Storage for masked copies of "p". */
    unsigned short yOffset;
    
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    xEndAddr = xAddr + ((width>>3) & ~1);
    rightOffset = width & 15;

    leftMask = 0xFFFF>>leftOffset;		/* e.g. 001111111111111 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Note that we must also correctly align the pattern vertically. */
    yOffset = (dst->y) & 15;

    /* Handle the special case of a single 'column' */
    if (width < 16)
      {
        leftMask &= rightMask;
	++leftOffset;
	rightOffset = 0;
      }

    /* Draw the left offset column: */
    --height;
    if (leftOffset > 0)
      {
	/* Make a masked copy of "p" in "maskedPat". */
	pat1 = p;
	pat2 = maskedPat;
	for (count = 0; count < 16; ++count)
	    *pat2++ = *pat1++ & leftMask;

	/* Now fill in the left column. */
	pat1 = maskedPat + yOffset;
	pat2 = maskedPat + 16;
	count = height;
	yAddr = xAddr;

        asm("paint_leftloop:");			/* do */
	    *(fbWord *)yAddr |= *pat1++; /* paint in the new bits. */
	    yAddr += screenWidth;
	    /* Reset "pat1" on every 16th iteration. */
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne paintpatll");
	    asm("lea a6@(-/28),a3"); /* pat1 = maskedPat; */
        asm("paintpatll: dbf d2,paint_leftloop");/* while (--count >= 0); */

	xAddr += 2;
      }

    /* Draw the right offset column. */
    if (rightOffset > 0)
      {
	pat1 = p;
	pat2 = maskedPat;
	for (count = 0; count < 16; ++count)
	    *pat2++ = *pat1++ & rightMask;

	pat1 = maskedPat + yOffset;
	pat2 = maskedPat + 16;
	count = height;
	yAddr = xEndAddr;

        asm("paint_rightloop:");		/* do */
	    *(fbWord *)yAddr |= *pat1++;
	    yAddr += screenWidth;
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne paintpatrl");
	    asm("lea a6@(-/28),a3"); /* pat1 = maskedPat; */
        asm("paintpatrl: dbf d2,paint_rightloop");/* while (--count >= 0); */

      }

    /* Draw the midsection, row by row. */
    width = (xEndAddr - xAddr)>>1;
    if (width-- > 0)
      {
	pat1 = p + yOffset;
	pat2 = p + 16;
	yAddr = xEndAddr;

        asm("paint_midouterloop:");		/* do */
	  {
	    count = width;
	    xAddr = yAddr;
	    leftMask = *pat1++;

            asm("paint_midinnerloop:");		/* do */
	    asm("orw d7,a5@-");			/* *(xAddr -= 2) |= leftMask; */
            asm("dbf d2,paint_midinnerloop");	/* while (--count >= 0); */

	    yAddr += screenWidth;
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne paintpatmol");
	    asm("movl a6@(/C),a3"); /* pat1 = workingPat; */
	  }
        asm("paintpatmol: dbf d4,paint_midouterloop");  /* while (--height >= 0); */

      }
  }

/* The following code is wrong - it does not take into account the fact that
 * patterns are aligned on 16-bit boundaries in the framebuffer.
 */
#ifdef IGNORE_THIS
Sun2_PutPattern(dst, p)
    fb_raster *dst;
    patPtr p;
    /* Fills the area "dst" with the pattern "p". */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register fbWord leftMask, rightMask;	/* d7, d6 */
    register screenWidth, height, width, count;	/* d5, d4, d3, d2 */
    register patPtr pat1, pat2;			/* a3, a2 */

    fbAddress xEndAddr;
    unsigned short leftOffset, rightOffset;
    patArray savedPat, maskedPat; /* Storage for local copies of "p". */
    patPtr workingPat;
    
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    xEndAddr = xAddr + ((width>>3) & ~1);
    rightOffset = width & 15;

    leftMask = 0xFFFF>>leftOffset;		/* e.g. 001111111111111 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Handle the special case of a single 'column' */
    if (width < 16)
      {
        leftMask &= rightMask;
	++leftOffset;
	rightOffset = 0;
      }

    /* Draw the left offset column: */
    --height;
    if (leftOffset > 0)
      {
	/* Make a rotated copy of "p" in "savedPat", and a masked copy of this
	 * in "maskedPat".
	 */
	pat1 = savedPat;
	pat2 = maskedPat;
	for (count = 0; count < 16; ++count)
	  {
	    /* Rotate "*p" right by "leftOffset", giving "*pat1". */
	    *pat1 = *p++;
	    *pat1 = (*pat1<<leftOffset) | (*pat1>>(16-leftOffset));
	    /* Mask off the extraneous left bits, giving "*pat2". */
	    *pat2++ = *pat1++ & leftMask;
	  }
	workingPat = savedPat;

	/* Now fill in the left column. */
	pat1 = maskedPat;
	pat2 = pat1+16;
	leftMask = ~leftMask;
	count = height;
	yAddr = xAddr;

        asm("put_leftloop:");			/* do */
	    *(fbWord *)yAddr &= leftMask; /* off with the old bits... */
	    *(fbWord *)yAddr |= *pat1++; /* ...and in with the new. */
	    yAddr += screenWidth;
	    /* Reset "pat1" on every 16th iteration. */
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne putpatll");
	    asm("lea a6@(-/48),a3"); /* pat1 = maskedPat; */
        asm("putpatll: dbf d2,put_leftloop");   /* while (--count >= 0); */

	xAddr += 2;
      }
    else /* just pretend to copy p. */
        workingPat = p;

    /* Draw the right offset column. */
    if (rightOffset > 0)
      {
	/* Make a masked copy of "workingPat" in "maskedPat". */
	pat1 = workingPat;
	pat2 = maskedPat;
	for (count = 0; count < 16; ++count)
	    /* Mask off the extraneous right bits of "*pat1", giving "*pat2". */
	    *pat2++ = *pat1++ & rightMask;

	pat1 = maskedPat;
	pat2 = pat1+16;
	rightMask = ~rightMask;
	count = height;
	yAddr = xEndAddr;

        asm("put_rightloop:");		/* do */
	    *(fbWord *)yAddr &= rightMask;
	    *(fbWord *)yAddr |= *pat1++;
	    yAddr += screenWidth;
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne putpatrl");
	    asm("lea a6@(-/48),a3"); /* pat1 = maskedPat; */
        asm("putpatrl: dbf d2,put_rightloop");  /* while (--count >= 0); */

      }

    /* Draw the midsection, row by row. */
    width = (xEndAddr - xAddr)>>1;
    if (width-- > 0)
      {
	pat1 = workingPat;
	pat2 = pat1+16;
	yAddr = xEndAddr;

        asm("put_midouterloop:");		/* do */
	  {
	    count = width;
	    xAddr = yAddr;
	    leftMask = *pat1++;

            asm("put_midinnerloop:");		/* do */
	    asm("movw d7,a5@-");		/* *(xAddr -= 2) = leftMask; */
            asm("dbf d2,put_midinnerloop");	/* while (--count >= 0); */

	    yAddr += screenWidth;
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne putpatmol");
	    asm("movl a6@(-/4C),a3"); /* pat1 = workingPat; */
	  }
        asm("putpatmol: dbf d4,put_midouterloop");/* while (--height >= 0); */

      }
  }



Sun2_PaintPattern(dst, p)
    fb_raster *dst;
    patPtr p;
    /* 'Paints' (black on white) the pattern "p" onto the area "dst".
     * That is, "p" is or'd onto "dst".
     */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register fbWord leftMask, rightMask;	/* d7, d6 */
    register screenWidth, height, width, count;	/* d5, d4, d3, d2 */
    register patPtr pat1, pat2;			/* a3, a2 */

    fbAddress xEndAddr;
    unsigned short leftOffset, rightOffset;
    patArray savedPat, maskedPat; /* Storage for local copies of "p". */
    patPtr workingPat;
    
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    xEndAddr = xAddr + ((width>>3) & ~1);
    rightOffset = width & 15;

    leftMask = 0xFFFF>>leftOffset;		/* e.g. 001111111111111 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Handle the special case of a single 'column' */
    if (width < 16)
      {
        leftMask &= rightMask;
	++leftOffset;
	rightOffset = 0;
      }

    /* Draw the left offset column: */
    --height;
    if (leftOffset > 0)
      {
	/* Make a rotated copy of "p" in "savedPat", and a masked copy of this
	 * in "maskedPat".
	 */
	pat1 = savedPat;
	pat2 = maskedPat;
	for (count = 0; count < 16; ++count)
	  {
	    /* Rotate "*p" right by "leftOffset", giving "*pat1". */
	    *pat1 = *p++;
	    *pat1 = (*pat1<<leftOffset) | (*pat1>>(16-leftOffset));
	    /* Mask off the extraneous left bits, giving "*pat2". */
	    *pat2++ = *pat1++ & leftMask;
	  }
	workingPat = savedPat;

	/* Now fill in the left column. */
	pat1 = maskedPat;
	pat2 = pat1+16;
	count = height;
	yAddr = xAddr;

        asm("paint_leftloop:");			/* do */
	    *(fbWord *)yAddr |= *pat1++; /* paint in the new bits. */
	    yAddr += screenWidth;
	    /* Reset "pat1" on every 16th iteration. */
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne paintpatll");
	    asm("lea a6@(-/48),a3"); /* pat1 = maskedPat; */
        asm("paintpatll: dbf d2,paint_leftloop");/* while (--count >= 0); */

	xAddr += 2;
      }
    else /* just pretend to copy p. */
        workingPat = p;

    /* Draw the right offset column. */
    if (rightOffset > 0)
      {
	/* Make a masked copy of "workingPat" in "maskedPat". */
	pat1 = workingPat;
	pat2 = maskedPat;
	for (count = 0; count < 16; ++count)
	    /* Mask off the extraneous right bits of "*pat1", giving "*pat2". */
	    *pat2++ = *pat1++ & rightMask;

	pat1 = maskedPat;
	pat2 = pat1+16;
	count = height;
	yAddr = xEndAddr;

        asm("paint_rightloop:");		/* do */
	    *(fbWord *)yAddr |= *pat1++;
	    yAddr += screenWidth;
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne paintpatrl");
	    asm("lea a6@(-/48),a3"); /* pat1 = maskedPat; */
        asm("paintpatrl: dbf d2,paint_rightloop");/* while (--count >= 0); */

      }

    /* Draw the midsection, row by row. */
    width = (xEndAddr - xAddr)>>1;
    if (width-- > 0)
      {
	pat1 = workingPat;
	pat2 = pat1+16;
	yAddr = xEndAddr;

        asm("paint_midouterloop:");		/* do */
	  {
	    count = width;
	    xAddr = yAddr;
	    leftMask = *pat1++;

            asm("paint_midinnerloop:");		/* do */
	    asm("orw d7,a5@-");			/* *(xAddr -= 2) |= leftMask; */
            asm("dbf d2,paint_midinnerloop");	/* while (--count >= 0); */

	    yAddr += screenWidth;
	    asm("cmpl a2,a3");	/* if (pat1 == pat2) */
	    asm("bne paintpatmol");
	    asm("movl a6@(-/4C),a3"); /* pat1 = workingPat; */
	  }
        asm("paintpatmol: dbf d4,paint_midouterloop");  /* while (--height >= 0); */

      }
  }
#endif IGNORE_THIS
