/*
 *		Sun-2 graphics library.
 *		Ross Finlayson, June 1984.
 */

/* Operations for transferring rasters from main memory to the framebuffer.
 *
 * Note that rasters are stored in main memory in column order, with no offset
 * to simplify 16-bit alignment in the framebuffer.  This is for compatibility
 * with the Sun-1 graphics library, but is a royal pain for the Sun-2, since
 * in general we will have to perform shifts and rotates on each word of the
 * raster.  Eventually we should develop a format which better suits the Sun-2.
 */
/* Exports:	Sun2_PutRaster(), Sun2_XorRaster, Sun2_PaintRaster(),
		Sun2_InvPaintRaster(). */

#include "sun2framebuffer.h"


Sun2_PutRaster(dst, src)
    fb_raster *dst;
    mem_raster *src;
    /* Fills the area "dst" with the raster "src". */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register char *memPtr, *rowPtr;		/* a3, a2 */

    /* We have only enough registers for the variables in the inner loops: */
    register fbWord leftMask, save, leftPart;	/* d7, d6, d5 */
    register height, xcount, leftOffset;	/* d4, d3, d2 */

    int width, ycount, rightOffset, screenWidth;
    fbWord rightMask;
    
    /* Take the width and height from "dst" rather than "src". */
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    rightOffset = width & 15;
    width >>= 4;

    leftMask = 0xFFFF0000>>leftOffset;		/* e.g. 110000000000000 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Draw the framebuffer raster, row by row. */
    memPtr = rowPtr = (char *)src->start;
    yAddr = xAddr;
    ycount = height;
    height <<= 1; /* now counts the # of bytes between columns in memory. */
    /* For efficiency, handle several cases separately: */
    if (leftOffset > 0)
      {
	/* Start of the raster in the framebuffer is NOT on a 16-bit boundary */
       if (leftOffset < rightOffset)
        while (--ycount >= 0)
	  {
	    xcount = width;
	    leftPart = *(fbWord *)xAddr;
	    leftPart &= leftMask;
	    goto put_test1;

            asm("put_xloop1:");	     /* do */
					/*  leftPart		   save   */
		save= *(fbWord *)memPtr;
		memPtr += height;
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d6");	/* | f |  0 |		| n |  m | */
		leftPart ^= save;	/* |f^n|  m |		| n |  m | */
		save &= leftMask;	/* |f^n|  m |		| n |  0 | */
		leftPart ^= save;	/* | f |  m |		| n |  0 | */
		asm("movw d5,a5@+");	/* *xAddr++ = leftPart; */
		leftPart = save;	/* | n |  0 |		| n |  0 | */
 put_test1: asm("dbf d3,put_xloop1");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)memPtr;
	    save >>= leftOffset;	/*    save	  *xAddr   */
	    save |= leftPart;		/* |  k | l |	|  g | h | */
	    save ^= *(fbWord *)xAddr;	/* | k^g|l^h|	|  g | h | */
	    save &= rightMask;		/* | k^g| 0 |	|  g | h | */
	    *(fbWord *)xAddr ^= save;	/* | k^g| 0 |	|  k | h | */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
       else /* leftOffset >= rightOffset: same as above except for right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    leftPart = *(fbWord *)xAddr;
	    leftPart &= leftMask;
	    goto put_test2;

            asm("put_xloop2:");	     /* do */
		save= *(fbWord *)memPtr;
		memPtr += height;
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d6");
		leftPart ^= save;
		save &= leftMask;
		leftPart ^= save;
		asm("movw d5,a5@+");
		leftPart = save;
 put_test2: asm("dbf d3,put_xloop2");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    leftPart ^= *(fbWord *)xAddr;
	    leftPart &= rightMask;
	    *(fbWord *)xAddr ^= leftPart;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
    else
      {
	/* Start of the raster in the framebuffer is on a 16-bit boundary */
       if (rightOffset > 0)
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto put_test3;

            asm("put_xloop3:");	/* do */
		asm("movw a3@,a5@+");	/* *xAddr = *memPtr++; */
		memPtr += height;
 put_test3: asm("dbf d3,put_xloop3");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)memPtr;
	    save ^= *(fbWord *)xAddr;
	    save &= rightMask;
	    *(fbWord *)xAddr ^= save;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
       else /* rightOffset == 0: same as above except: no right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto put_test4;

            asm("put_xloop4:");	/* do */
		asm("movw a3@,a5@+");	/* *xAddr = *memPtr++;*/
		memPtr += height;
 put_test4: asm("dbf d3,put_xloop4");/* while (--xcount >= 0); */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
  }



Sun2_XorRaster(dst, src)
    fb_raster *dst;
    mem_raster *src;
    /* XORs the raster "src" into the area "dst". */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register char *memPtr, *rowPtr;		/* a3, a2 */

    /* We have only enough registers for the variables in the inner loops: */
    register fbWord leftMask, save, leftPart;	/* d7, d6, d5 */
    register height, xcount, leftOffset;	/* d4, d3, d2 */

    int width, ycount, rightOffset, screenWidth;
    fbWord rightMask;
    
    /* Take the width and height from "dst" rather than "src". */
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    rightOffset = width & 15;
    width >>= 4;

    leftMask = 0xFFFF0000>>leftOffset;		/* e.g. 110000000000000 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Draw the framebuffer raster, row by row. */
    memPtr = rowPtr = (char *)src->start;
    yAddr = xAddr;
    ycount = height;
    height <<= 1; /* now counts the # of bytes between columns in memory. */
    /* For efficiency, handle several cases separately: */
    if (leftOffset > 0)
      {
	/* Start of the raster in the framebuffer is NOT on a 16-bit boundary */
       if (leftOffset < rightOffset)
        while (--ycount >= 0)
	  {
	    xcount = width;
	    leftPart = 0;
	    goto xor_test1;

            asm("xor_xloop1:");	/* do */
					/*  leftPart		   save   */
		save= *(fbWord *)memPtr;
		memPtr += height;
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d6");	/* | f |  0 |		| n |  m | */
		leftPart ^= save;	/* |f^n|  m |		| n |  m | */
		save &= leftMask;	/* |f^n|  m |		| n |  0 | */
		leftPart ^= save;	/* | f |  m |		| n |  0 | */
		asm("eorw d5,a5@+");	/* *xAddr++ ^= leftPart;*/
		leftPart = save;	/* | n |  0 |		| n |  0 | */
 xor_test1: asm("dbf d3,xor_xloop1");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)memPtr;
	    save >>= leftOffset;	/*    save	  *xAddr   */
	    save |= leftPart;		/* |  k | l |	|  g | h | */
	    save &= rightMask;		/* |  k | 0 |	|  g | h | */
	    *(fbWord *)xAddr ^= save;	/* |  k | 0 |	| g^k| h | */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
       else /* leftOffset >= rightOffset: same as above except for right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    leftPart = 0;
	    goto xor_test2;

            asm("xor_xloop2:");	/* do */
		save= *(fbWord *)memPtr;
		memPtr += height;
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d6");
		leftPart ^= save;
		save &= leftMask;
		leftPart ^= save;
		asm("eorw d5,a5@+");
		leftPart = save;
 xor_test2: asm("dbf d3,xor_xloop2");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    leftPart &= rightMask;
	    *(fbWord *)xAddr ^= leftPart;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
    else
      {
	/* Start of the raster in the framebuffer is on a 16-bit boundary */
       if (rightOffset > 0)
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto xor_test3;

            asm("xor_xloop3:");	     /* do */
		save = *(fbWord *)memPtr;
		asm("eorw d6,a5@+");	/* *xAddr++ ^= save; */
		memPtr += height;
 xor_test3: asm("dbf d3,xor_xloop3");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)memPtr;
	    save &= rightMask;
	    *(fbWord *)xAddr ^= save;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
       else /* rightOffset == 0: same as above except: no right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto xor_test4;

            asm("xor_xloop4:");	     /* do */
		save = *(fbWord *)memPtr;
		asm("eorw d6,a5@+");	/* *xAddr++ ^= save; */
		memPtr += height;
 xor_test4: asm("dbf d3,xor_xloop4");/* while (--xcount >= 0); */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
  }



Sun2_PaintRaster(dst, src)
    fb_raster *dst;
    mem_raster *src;
    /* 'Paints' (black on white) the raster "src" onto the area "dst".
     * That is, "dst" <- "dst" | "src".
     */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register char *memPtr, *rowPtr;		/* a3, a2 */

    /* We have only enough registers for the variables in the inner loops: */
    register fbWord leftMask, save, leftPart;	/* d7, d6, d5 */
    register height, xcount, leftOffset;	/* d4, d3, d2 */

    int width, ycount, rightOffset, screenWidth;
    fbWord rightMask;
    
    /* Take the width and height from "dst" rather than "src". */
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    rightOffset = width & 15;
    width >>= 4;

    leftMask = 0xFFFF0000>>leftOffset;		/* e.g. 110000000000000 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Draw the framebuffer raster, row by row. */
    memPtr = rowPtr = (char *)src->start;
    yAddr = xAddr;
    ycount = height;
    height <<= 1; /* now counts the # of bytes between columns in memory. */
    /* For efficiency, handle several cases separately: */
    if (leftOffset > 0)
      {
	/* Start of the raster in the framebuffer is NOT on a 16-bit boundary */
       if (leftOffset < rightOffset)
        while (--ycount >= 0)
	  {
	    xcount = width;
	    leftPart = 0;
	    goto paint_test1;

            asm("paint_xloop1:");     /* do */
					/*  leftPart		   save   */
		save= *(fbWord *)memPtr;
		memPtr += height;
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d6");	/* | f |  0 |		| n |  m | */
		leftPart ^= save;	/* |f^n|  m |		| n |  m | */
		save &= leftMask;	/* |f^n|  m |		| n |  0 | */
		leftPart ^= save;	/* | f |  m |		| n |  0 | */
		asm("orw d5,a5@+");	/* *xAddr++ |= leftPart; */
		leftPart = save;	/* | n |  0 |		| n |  0 | */
paint_test1:asm("dbf d3,paint_xloop1");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)memPtr;
	    save >>= leftOffset;	/*    save	  *xAddr   */
	    save |= leftPart;		/* |  k | l |	|  g | h | */
	    save &= rightMask;		/* |  k | 0 |	|  g | h | */
	    *(fbWord *)xAddr |= save;	/* |  k | 0 |	| g|k| h | */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
       else /* leftOffset >= rightOffset: same as above except for right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    leftPart = 0;
	    goto paint_test2;

            asm("paint_xloop2:");     /* do */
		save= *(fbWord *)memPtr;
		memPtr += height;
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d6");
		leftPart ^= save;
		save &= leftMask;
		leftPart ^= save;
		asm("orw d5,a5@+");
		leftPart = save;
paint_test2:asm("dbf d3,paint_xloop2");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    leftPart &= rightMask;
	    *(fbWord *)xAddr |= leftPart;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
    else
      {
	/* Start of the raster in the framebuffer is on a 16-bit boundary */
       if (rightOffset > 0)
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto paint_test3;

            asm("paint_xloop3:");     /* do */
		save = *(fbWord *)memPtr;
		asm("orw d6,a5@+");	/* *xAddr++ |= save; */
		memPtr += height;
paint_test3:asm("dbf d3,paint_xloop3");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)memPtr;
	    save &= rightMask;
	    *(fbWord *)xAddr |= save;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
       else /* rightOffset == 0: same as above except: no right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto paint_test4;

            asm("paint_xloop4:");     /* do */
		save = *(fbWord *)memPtr;
		asm("orw d6,a5@+");	/* *xAddr++ |= save; */
		memPtr += height;
paint_test4:asm("dbf d3,paint_xloop4");/* while (--xcount >= 0); */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
  }



Sun2_InvPaintRaster(dst, src)
    fb_raster *dst;
    mem_raster *src;
    /* 'Paints' (white on black) the raster "src" onto the area "dst".
     * That is, "dst" <- "dst" & "src".
     */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register char *memPtr, *rowPtr;		/* a3, a2 */

    /* We have only enough registers for the variables in the inner loops: */
    register fbWord leftMask, save, leftPart;	/* d7, d6, d5 */
    register height, xcount, leftOffset;	/* d4, d3, d2 */

    int width, ycount, rightOffset, screenWidth;
    fbWord rightMask;
    
    /* Take the width and height from "dst" rather than "src". */
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    rightOffset = width & 15;
    width >>= 4;

    leftMask = 0xFFFF0000>>leftOffset;		/* e.g. 110000000000000 */
    rightMask = 0xFFFF>>rightOffset;		/* e.g. 000011111111111 */

    /* Draw the framebuffer raster, row by row. */
    memPtr = rowPtr = (char *)src->start;
    yAddr = xAddr;
    ycount = height;
    height <<= 1; /* now counts the # of bytes between columns in memory. */
    /* For efficiency, handle several cases separately: */
    if (leftOffset > 0)
      {
	/* Start of the raster in the framebuffer is NOT on a 16-bit boundary */
       if (leftOffset < rightOffset)
        while (--ycount >= 0)
	  {
	    xcount = width;
	    leftPart = leftMask;
	    goto invpaint_test1;

            asm("invpaint_xloop1:");     /* do */
					/*  leftPart		   save   */
		save= *(fbWord *)memPtr;
		memPtr += height;
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d6");	/* | f |  0 |		| n |  m | */
		leftPart ^= save;	/* |f^n|  m |		| n |  m | */
		save &= leftMask;	/* |f^n|  m |		| n |  0 | */
		leftPart ^= save;	/* | f |  m |		| n |  0 | */
		asm("andw d5,a5@+");	/* *xAddr++ &= leftPart; */
		leftPart = save;	/* | n |  0 |		| n |  0 | */
invpaint_test1:asm("dbf d3,invpaint_xloop1");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)memPtr;
	    save >>= leftOffset;	/*    save	  *xAddr   */
	    save |= leftPart;		/* |  k | l |	|  g | h | */
	    save |= rightMask;		/* |  k | 1 |	|  g | h | */
	    *(fbWord *)xAddr &= save;	/* |  k | 1 |	| g&k| h | */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
       else /* leftOffset >= rightOffset: same as above except for right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    leftPart = leftMask;
	    goto invpaint_test2;

            asm("invpaint_xloop2:");     /* do */
		save= *(fbWord *)memPtr;
		memPtr += height;
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d6");
		leftPart ^= save;
		save &= leftMask;
		leftPart ^= save;
		asm("andw d5,a5@+");
		leftPart = save;
invpaint_test2:asm("dbf d3,invpaint_xloop2");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    leftPart |= rightMask;
	    *(fbWord *)xAddr &= leftPart;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
    else
      {
	/* Start of the raster in the framebuffer is on a 16-bit boundary */
       if (rightOffset > 0)
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto invpaint_test3;

            asm("invpaint_xloop3:");     /* do */
		save = *(fbWord *)memPtr;
		asm("andw d6,a5@+");	/* *xAddr++ &= save; */
		memPtr += height;
invpaint_test3:asm("dbf d3,invpaint_xloop3");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)memPtr;
	    save |= rightMask;
	    *(fbWord *)xAddr &= save;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
       else /* rightOffset == 0: same as above except: no right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto invpaint_test4;

            asm("invpaint_xloop4:");     /* do */
		save = *(fbWord *)memPtr;
		asm("andw d6,a5@+");	/* *xAddr++ &= save; */
		memPtr += height;
invpaint_test4:asm("dbf d3,invpaint_xloop4");/* while (--xcount >= 0); */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
  }
