/*
 *		Sun-2 graphics library.
 *		Ross Finlayson, October 1984.
 */

/* General line drawing routine (uses Bresenham's algorithm). */
/* Exports:	Sun2_Line(). */

#include "sun2framebuffer.h"


Sun2_Line(x, y, dx, dy)
    unsigned short x, y;
    register short dx, dy; 		/* d7, d6.  (Can be negative.) */
    /* Draws a (1 pixel wide) line from (x,y) to (x+dx,y+dy). */
  {
    register fbAddress pointAddr;	/* a5 */

    register fbWord lineBit;		/* d5 */
    register short e, majCount;		/* d4, d3 */
    register screenWidth;		/* d2 */

    /* Change the parameters so that "dx" > 0. */
    if (dx < 0)
      {
	x -= (dx = -dx);
	y -= (dy = -dy);
      }
    if (x + dx > ScreenLimitX) return; /* integrity check. */

    /* Compute the address of the origin point (x,y): */
    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    pointAddr = (fbAddress) GXBase;	/* Frame buffer base address */
    pointAddr += mult(y, screenWidth);	/* + rows above the point */
    pointAddr += (x>>3) & ~1;		/* + space to the left */
        
    /* Set up "lineBit", a 1-bit value that will be or'd into the framebuffer
     * to draw the line.
     */
    lineBit = 0x8000>>(x & 15);

    /* We consider the following four cases (each angle is 45 degrees):
     *
     *-Y
     * |     /
     * | 3  /
     * |   /
     * |  /
     * | /  4
     * |/
     * *--------> +X
     * |\
     * | \  2
     * |  \
     * |   \
     * | 1  \
     * |     \
     *+Y
     *
     */
    if (dy < 0)
      { /* Case 3 or 4. */
	dy = -dy;
	if ( ((int)(y - dy) < 0) || (y >= ScreenLimitY) )
	    return; /* integrity check. */
	screenWidth = -screenWidth; /* move 'upwards' instead of 'downwards'. */
      }
    else /* (dy >= 0) */
      { /* Case 1 or 2. */
	if (y + dy >= ScreenLimitY) return; /* integrity check. */
      }

    /* Draw the line. */
    if (dx <= dy)
      { /* Case 1 or 3 - major direction is Y, minor is X. */
	majCount = dy;
	e = -dy;
	dx <<= 1; dy <<= 1; /* multiply each by 2. */
	do  /* (minor direction loop) */
	  {
	    asm("major13:");	   /* do   (major direction loop) */
		*(fbWord *)pointAddr |= lineBit; /* plot a point. */
		pointAddr += screenWidth;
		e += dx;
	    asm("dbgt d3,major13");/* while ((e <= 0) && (--majCount != -1)); */
	    asm("rorw #1,d5");	   /* rotate "lineBit" right by 1. */
	    asm("bcc cont13"); 	   /* if (lineBit == 0x8000) */
	        pointAddr += 2;
	    asm("cont13:");
	    e -= dy;
	  }
	while (--majCount >= 0);
      }
    else /* (dx > dy) */
      { /* Cases 2 or 4 - major direction is X, minor is Y. */
	majCount = dx;
	e = -dx;
	dx <<= 1; dy <<= 1; /* multiply each by 2. */
	do  /* (minor direction loop) */
	  {
	    asm("major24:");	   /* do   (major direction loop) */
		*(fbWord *)pointAddr |= lineBit; /* plot a point. */
		asm("rorw #1,d5");     /* rotate "lineBit" right by 1. */
		asm("bcc cont24");     /* if (lineBit == 0x8000) */
		    pointAddr += 2;
		asm("cont24:");
		e += dy;
	    asm("dbgt d3,major24");/* while ((e <= 0) && (--majCount != -1)); */
	    pointAddr += screenWidth;
	    e -= dx;
	  }
	while (--majCount >= 0);
      }
  }
