/*
 *		Sun-2 graphics library.
 *		Ross Finlayson, June 1984.
 */

/* Operations for transferring rasters from the framebuffer to main memory.
 *
 * Note that rasters are stored in main memory in column order, with no offset
 * to simplify 16-bit alignment in the framebuffer.  This is for compatibility
 * with the Sun-1 graphics library, but is a royal pain for the Sun-2, since
 * in general we will have to perform shifts and rotates on each word of the
 * raster.  Eventually we should develop a format which better suits the Sun-2.
 */
/* Exports:	Sun2_GetRaster(). */

#include "sun2framebuffer.h"


Sun2_GetRaster(dst, src)
    mem_raster *dst;
    fb_raster *src;
    /* Fills the area "dst" with the raster "src", from the framebuffer. */
  {
    register fbAddress xAddr, yAddr;		/* a5, a4 */
    register char *memPtr, *rowPtr;		/* a3, a2 */

    /* We have only enough registers for the variables in the inner loops: */
    register fbWord leftMask, save, leftPart;	/* d7, d6, d5 */
    register height, xcount, leftOffset;	/* d4, d3, d2 */

    int width, ycount, rightOffset, screenWidth;
    
    /* Take the width and height from "dst" rather than "src". */
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(src->y, screenWidth);	/* + rows above the raster */
    xAddr += (src->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = src->x & 15; /* (src->x)%16 */
    rightOffset = (leftOffset + width) & 15;

    leftMask = 0xFFFF<<leftOffset;		/* e.g. 1111111111111100 */

    /* Copy the framebuffer raster to main memory, row by row. */
    width = (width + 15)>>4; /* number of 16-bit words taken up in main mem. */
    memPtr = rowPtr = (char *)dst->start;
    yAddr = xAddr;
    ycount = height;
    height <<= 1; /* now counts the # of bytes between columns in memory. */
    /* For efficiency, handle several cases separately: */
    if (leftOffset > 0)
      {
	/* Start of the raster in the framebuffer is NOT on a 16-bit boundary */
       if (leftOffset < rightOffset)
	{--width;
        while (--ycount >= 0)
	  {
	    xcount = width;
	    asm("movw a5@+,d5");	/* leftPart = *xAddr++; */
	    leftPart <<= leftOffset;
	    goto get_test1;

            asm("get_xloop1:");	     /* do */
		asm("movw a5@+,d6");	/* save = *xAddr++; */
					/*  leftPart		   save   */
		/* rotate "save" left by "leftOffset": */
		asm("rolw d2,d6");	/* |  f | 0 |		|  h | g | */
		leftPart ^= save;	/* | f^h| g |		|  h | g | */
		save &= leftMask;	/* | f^h| g |		|  h | 0 | */
		leftPart ^= save;	/* |  f | g |		|  h | 0 | */
		*(fbWord *)memPtr = leftPart;
		memPtr += height;
		leftPart = save;	/* |  h | 0 |		|  h | 0 | */
 get_test1: asm("dbf d3,get_xloop1");/* while (--xcount >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    *(fbWord *)memPtr = leftPart;
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
	}
       else /* leftOffset >= rightOffset: same as above except: no right word */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    asm("movw a5@+,d5");	/* leftPart = *xAddr++; */
	    leftPart <<= leftOffset;
	    goto get_test2;

            asm("get_xloop2:");	     /* do */
		asm("movw a5@+,d6");	/* save = *xAddr++; */
		/* rotate "save" left by "leftOffset": */
		asm("rolw d2,d6");
		leftPart ^= save;
		save &= leftMask;
		leftPart ^= save;
		*(fbWord *)memPtr = leftPart;
		memPtr += height;
		leftPart = save;
 get_test2: asm("dbf d3,get_xloop2");/* while (--xcount >= 0); */

	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
    else
      {
	/* Start of the raster in the framebuffer is on a 16-bit boundary */
        while (--ycount >= 0)
	  {
	    xcount = width;
	    goto get_test3;

            asm("get_xloop3:");	/* do */
		asm("movw a5@+,a3@");	/* *memPtr = *xAddr++; */
		memPtr += height;
 get_test3: asm("dbf d3,get_xloop3");/* while (--xcount >= 0); */
	    
	    rowPtr += 2;
	    memPtr = rowPtr;
	    yAddr += screenWidth;
	    xAddr = yAddr;
	  }
      }
  }
