/*
 *		Sun-2 graphics library.
 *		Ross Finlayson, June 1984.
 */

/* Operations for moving rasters within the framebuffer. */
/* Exports:	Sun2_CopyRaster(). */

#include "sun2framebuffer.h"


Sun2_CopyRaster(dst, src)
    fb_raster *dst, *src;
    /* Copies the framebuffer raster "src" to the framebuffer raster "dst". */
  {
    register fbAddress dstxAddr, dstyAddr,	/* a5, a4 */
		       srcxAddr, srcyAddr;	/* a3, a2 */

    register fbWord leftMask, rightMask, save, leftPart; /* d7, d6, d5, d4 */
    register count, leftOffset;			 /* d3, d2 */

    fbAddress srcSaveAddr;
    fbWord dstleftMask, srcleftMask, srcSave;
    int height, width, screenWidth, dstleftOffset, srcleftOffset, rightOffset;
    
    /* Take the width and height from "dst" rather than "src". */
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner ("src" and "dst"): */
    dstyAddr = (fbAddress) GXBase;	/* Frame buffer base address */
    dstxAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    dstyAddr += (dst->x>>3) & ~1;	/* + space to the left */
    srcyAddr = (fbAddress) GXBase;
    dstxAddr += mult(src->y, screenWidth);
    srcyAddr += (src->x>>3) & ~1;
        
    dstleftOffset = dst->x & 15; /* (dst->x)%16 */
    srcleftOffset = src->x & 15;

    /* Condider 3 cases separately: */
    if (dstleftOffset > srcleftOffset)
      {
	dstleftMask = 0xFFFF0000>>dstleftOffset; /* e.g. 1111100000000000 */
	srcleftMask = 0xFFFF>>srcleftOffset;	 /* e.g. 0011111111111111 */
	leftOffset = dstleftOffset - srcleftOffset;
	leftMask = 0xFFFF0000>>leftOffset;	 /* e.g. 1110000000000000 */
	width += dstleftOffset;
	rightOffset = width & 15;
	rightMask = 0xFFFF0000>>rightOffset;
	width >>= 4;

	/* Copy "src" to "dst", row by row. */
	while (--height >= 0)
	  {
	    dstxAddr = dstyAddr;
	    srcxAddr = srcyAddr;

	    count = width;
	    leftPart = *(fbWord *)dstxAddr;
	    leftPart &= dstleftMask;
	    /* save the left source word, and mask off the left part (kludge) */
	    srcSaveAddr = srcxAddr;
	    srcSave = *(fbWord *)srcSaveAddr;
	    *(fbWord *)srcSaveAddr &= srcleftMask;
	    goto copy_test1;
		
	    asm("copy_xloop1:");     /* do */
		asm("movw a3@+,d5");	/* save = *srcxAddr++; */
				  	/*  leftPart		   save   */
		/* rotate "save" right by "leftOffset": */
		asm("rorw d2,d5");	/* | f |  0 |		| n |  m | */
		leftPart ^= save;	/* |f^n|  m |		| n |  m | */
		save &= leftMask;	/* |f^n|  m |		| n |  0 | */
		leftPart ^= save;	/* | f |  m |		| n |  0 | */
		asm("movw d4,a5@+");/* *dstxAddr++ = leftPart; */
		leftPart = save;	/* | n |  0 |		| n |  0 | */
copy_test1: asm("dbf d3,copy_xloop1");/* while (--count >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    save = *(fbWord *)srcxAddr;
	    save >>= leftOffset;	/*    save		  *dstxAddr   */
	    save |= leftPart;		/* |  k | l |		|  g | h | */
	    save ^= *(fbWord *)dstxAddr;/* | k^g|l^h|		|  g | h | */
	    save &= rightMask;		/* | k^g| 0 |		|  g | h | */
	    *(fbWord *)dstxAddr ^= save;/* | k^g| 0 |		|  k | h | */
	    /* restore the left source word: */
	    *(fbWord *)srcSaveAddr = srcSave;
	    
	    dstyAddr += screenWidth;
	    srcyAddr += screenWidth;
	  }
      }
    else if (dstleftOffset < srcleftOffset)
      {
	dstleftMask = 0xFFFF0000>>dstleftOffset; /* e.g. 1110000000000000 */
	srcleftMask = 0xFFFF>>srcleftOffset;	 /* e.g. 0000011111111111 */
	leftOffset = srcleftOffset - dstleftOffset;
	leftMask = 0xFFFF<<leftOffset;		 /* e.g. 1111111111111100 */
	width += dstleftOffset;
	rightOffset = width & 15;
	rightMask = 0xFFFF0000>>rightOffset;
	width >>= 4;

	/* Copy "src" to "dst", row by row. */
	while (--height >= 0)
	  {
	    dstxAddr = dstyAddr;
	    srcxAddr = srcyAddr;

	    count = width;
	    asm("movw a3@+,d4");	/* leftPart = *srcxAddr++; */
	    leftPart &= srcleftMask;
	    leftPart <<= leftOffset;
	    save = *(fbWord *)dstxAddr;
	    save &= dstleftMask;
	    leftPart |= save;
	    goto copy_test2;
		
	    asm("copy_xloop2:");     /* do */
		asm("movw a3@+,d5");	/* save = *srcxAddr++; */
				  	/*  leftPart		   save   */
		/* rotate "save" left by "leftOffset": */
		asm("rolw d2,d5");	/* | f |  0 |		| n |  m | */
		leftPart ^= save;	/* |f^n|  m |		| n |  m | */
		save &= leftMask;	/* |f^n|  m |		| n |  0 | */
		leftPart ^= save;	/* | f |  m |		| n |  0 | */
		asm("movw d4,a5@+");/* *dstxAddr++ = leftPart; */
		leftPart = save;	/* | n |  0 |		| n |  0 | */
copy_test2: asm("dbf d3,copy_xloop2");/* while (--count >= 0); */
	    /* The right-hand word of this row is handled separately: */
	    leftPart ^= *(fbWord *)dstxAddr;
	    leftPart &= rightMask;
	    *(fbWord *)dstxAddr ^= leftPart;
	    
	    dstyAddr += screenWidth;
	    srcyAddr += screenWidth;
	  }
      }
    else /* dstleftOffset == srcleftOffset */
	/* The easy case - a simple copy, except for the end words. */
      {
	fbAddress dstxEndAddr, srcxEndAddr;
 
	leftOffset = dstleftOffset;
	leftMask = 0xFFFF>>leftOffset;		/* e.g. 0001111111111111 */
	width += leftOffset;
	rightOffset = width & 15;
	rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 1111100000000000 */
	width >>= 4;

	dstxAddr = dstyAddr;
	srcxAddr = srcyAddr;
	dstxEndAddr = dstxAddr + (width<<1);
	srcxEndAddr = srcxAddr + (width<<1);

	/* Handle the special case of a single 'column' */
	if (width == 0)
	  {
	    leftMask &= rightMask;
	    ++leftOffset;
	    rightOffset = 0;
	  }

	/* Draw the left offset column: */
	--height;
	if (leftOffset > 0)
	  {
	    count = height;
		
	    asm("copy_leftloop:");		/* do */
		save = *(fbWord *)srcyAddr;
		save ^= *(fbWord *)dstyAddr;
		save &= leftMask;
		*(fbWord *)dstyAddr ^= save;
		dstyAddr += screenWidth;
		srcyAddr += screenWidth;
	    asm("dbf d3,copy_leftloop");	/* while (--count >= 0); */

	    dstxAddr += 2;
	    srcxAddr += 2;
	    --width;
	  }
	      
	/* Draw the right offset column. */
	if (rightOffset > 0)
	  {
	    count = height;
	    dstyAddr = dstxEndAddr;
	    srcyAddr = srcxEndAddr;
		
	    asm("copy_rightloop:");		/* do */
		save = *(fbWord *)srcyAddr;
		save ^= *(fbWord *)dstyAddr;
		save &= rightMask;
		*(fbWord *)dstyAddr ^= save;
		dstyAddr += screenWidth;
		srcyAddr += screenWidth;
	    asm("dbf d3,copy_rightloop");	/* while (--count >= 0); */
	  }
	      
	/* Draw the midsection, row by row. */
	if (width-- > 0)
	  {
	    dstyAddr = dstxAddr;
	    srcyAddr = srcxAddr;
		
	    do
	      {
		count = width;
		    
		asm("copy_midloop:");	   /* do */
		    asm("movw a3@+,a5@+");	/* *dstxAddr++ = *srcxAddr++; */
		asm("dbf d3,copy_midloop");/* while (--count >= 0); */

		dstyAddr += screenWidth;
		srcyAddr += screenWidth;
		dstxAddr = dstyAddr;
		srcxAddr = srcyAddr;
	      }
	    while (--height >= 0);		
	  }
      }
  }
