/*
 * text.c - Some simple text primitives
 *
 * Bill Nowicki August 1982
 */

# include <framebuf.h>
# include <rasterops.h>

# define FontHeight 16
# define FontWidth 8
# define FontMultiplier (FontHeight*FontWidth/8)

extern short WideStandardFont[];

DrawText( left, bottom, string, length, paintFlag )
  int left, bottom;
  register char *string;	/* a5 */
  short length;
  int paintFlag;		/* true means paint instead of draw */
{
  /*
   * Print the given string in the given place on the screen
   */
    register int i;		/* d7 */
    register int top;		/* d6 */
    register int normal;	/* d5 */
    register int inverted;	/* d4 */
    register short *x;		/* a4 */
    register short *funct;	/* a3 */
    register short *map;	/* a2 */
 /* register short *y;   	a0  (Unknown to compiler) */
 /* register short *mapStart;	a1  (Unknown to compiler) */

    if (paintFlag)
      {
        normal = GXpaintInverted;
	inverted = GXand;
      }
    else
      {
        normal = GXcopyInverted;
	inverted = GXcopy;
      }
    x = (short *)(GXBase|GXselectX)+left;
    funct = &(GXfunction);
    top = (GXBase|GXupdate|GXselectY|GXsource)
    			+ ( (bottom - FontHeight + 1)<<1 );
    GXwidth = FontWidth;
    asm("	movl	#WideStandardFont,a1");
    for (i = length; i>0; i--)
      {
        *x = i;
        *funct = (*string<0) ? inverted : normal;
/**     map = WideStandardFont;
 *
 * Optimized
 *	map += ( (*string++) & 0177) * FontMultiplier;
 */
 	asm("	movl	a1,a2");
	asm("	movb	a5@+,d0");
	asm("	andl	#127,d0");
	asm("	asll	#5,d0");
	asm("	addl	d0,a2");
	asm("	movl	d6,a0");
	asm("	movl	a2@+,a0@+");
	asm("	movl	a2@+,a0@+");
	asm("	movl	a2@+,a0@+");
	asm("	movl	a2@+,a0@+");
	asm("	movl	a2@+,a0@+");
	asm("	movl	a2@+,a0@+");
	asm("	movl	a2@+,a0@+");
	x += FontWidth;
	asm("	movl	a2@+,a0@+");  
      }
}


ClipText( left, bottom, string, length, paintFlag, topLimit, botLimit )
  int left, bottom, topLimit, botLimit;
  register char *string;	/* a5 */
  short length;
  int paintFlag;		/* true means paint instead of draw */
{
  /*
   * Print the given string in the given place on the screen
   */
    register int j;		/* d7 */
    register int top;		/* d6 */
    register short normal;	/* d5 */
    register short inverted;	/* d4 */
    register short offset;	/* d3 */
    register short count;	/* d2 */
    register short *x;		/* a4 */
    register short *y;		/* a3 */
    register short *map;	/* a2 */
    	     int i;

    if (paintFlag)
      {
        normal = GXpaintInverted;
	inverted = GXand;
      }
    else
      {
        normal = GXcopyInverted;
	inverted = GXcopy;
      }
    bottom &= 1023;
    left   &= 1023;
    x = (short *)(GXBase|GXselectX)+left;
    top = bottom - FontHeight + 1;
    if (top<topLimit)
      {
      		/*
		 * calculate the number of scan-lines we have to skip.
		 * if we skip everything, don't bother doing anything.
		 */
         offset = topLimit - top;
	 if (offset>=FontHeight) return;
      }
    else offset = 0;

    if (bottom>botLimit)
      {
         count = botLimit - top - offset + 1;
	 if (count<=0) return;
      }
    else
      count = FontHeight - offset;

    top = (GXBase|GXupdate|GXselectY|GXsource)
    			+ ( (top + offset)<<1 );
    GXwidth = FontWidth;
    for (i = length; i>0; i--)
      {
        *x = i;
        GXfunction = (*string<0) ? inverted : normal;
        map = WideStandardFont;
	map += ( (*string++) & 0177) * FontMultiplier;
	y = (short *)top;
	for (j=count;j>0;j--)
	  *y++ = *map++;
	x += FontWidth;
      }
}
