/* ShowRaster: displays a MemRaster bitmap, optionally clipped and magnified.
 * Per Bothner. March 1983
 * Replaced reference to GXDefaultBase by extern GXBase. PB. April 1984.
 */
#include <bitmaps.h>
#include <rasterops.h>
#include <framebuf.h>
#define seq4(h) h/**/0,h/**/3,h/**/C,h/**/F
unsigned char mul2[16] = {seq4(0x0),seq4(0x3),seq4(0xC),seq4(0xF)};
unsigned short mul4[16] = {0,0xF,0xF0,0xFF,0xF00,0xF0F,0xFF0,0xFFF,
	0xF000,0xF00F,0xF0F0,0xF0FF,0xFF00,0xFF0F,0xFFF0,0xFFFF};
unsigned short mul8[4] = {0,0xFF,0xFF00,0xFFFF};

ShowRaster(in,x,y,scale,bBox)
  MemRaster *in;		/* the MemRaster to display */
  int x,y;			/* top, left corner of FB rectangle. */
  register int scale;		/* one of the ScaleXX defined in bitmaps.h */
  struct fb_raster *bBox;	/* clipping rectangle */
  {
    short moreWidth = in->width;
    short curOffset = in->bitOffset;
    int height = in->height;
    short curWidth;
    register shift, i;
    register char *RegGXBase = (char*)GXBase;
#define GXBase RegGXBase
    register short *yFB = y + (short *)((GXupdate|GXselectY|GXsource)+GXBase);
    u_short *colTop = in->start;
    register u_short *memPtr;
    short maxColWidth = 16 >> scale;

    if (x < bBox->x)
      { /* left clipping */
	i = (bBox->x - x) + (1 << scale) - 1;
	i >>= scale;
	x += i << scale;
	moreWidth -= i;
	if (moreWidth <= 0) return;
	curOffset += i;
	colTop += in->stride * (curOffset >> 4);
	curOffset &= 0xF;
      }
    if (y < bBox->y)
      { /* top clipping */
	i = (bBox->y - y) + (1 << scale) - 1;
	i >>= scale;
	height -= i;
	if (height <= 0) return;
	colTop += i;
	i <<= scale;
	y += i;
	yFB += i;
      }
    i = x - bBox->x - bBox->width + (moreWidth << scale);
    if (i >= 0 && ((scale&ScaleFramed && ++i) || i > 0))
      { /* right clipping */
	i += (1 << scale) - 1;
	moreWidth -= i >> scale;
	if (moreWidth <= 0) return;
      }
    i = y - bBox->y - bBox->height + (height << scale);
    if (i >= 0 && ((scale&ScaleFramed && ++i) || i > 0))
      { /* bottom clipping */
	i += (1 << scale) - 1;
	height -= i >> scale;
	if (height <= 0) return;
      }
    if (scale & ScaleFramed && x >= bBox->x)
      { /* draw vertical line to left of bitmap */
        GXwidth = 1;
	GXBase[x<<1] = i;
	shift = -1;
	for (i = height << scale; i >= 0; i--) *yFB++ = shift;
	yFB -= (height << scale) + 1;
	x++;
      }
    while (moreWidth > 0)
      { /* for each column of upto 16 bits ... */
        curWidth = 16 - curOffset;
	if (curWidth > moreWidth) curWidth = moreWidth;
	if (curWidth > maxColWidth) curWidth = maxColWidth;
	memPtr = colTop;
	shift = 16 - curOffset - curWidth;
	GXwidth = curWidth << scale;
	GXBase[x<<1] = shift;
        switch(scale)
	  { register j; register u_short word;
	    case Scale1:
		for (i = height; i > 0; i--)
		  { 
		    word = (*memPtr++ >> shift) & ~(-1 << curWidth);
		    *yFB++ = (word <<= 16 - curWidth);
		  }
	        break;
	    case Scale2:
		for (i = height; i > 0; i--)
		  { 
	    	    word = (*memPtr++ >> shift) & ~(-1 << curWidth);
	            word = (mul2[word >> 4] << 8) | mul2[word & 0xF];
		    word <<= 16 - (curWidth << 1);
		    *yFB++ = word; *yFB++ = word;
		  }
		break;
	    case Scale4:
		for (i = height; i > 0; i--)
		  { 
		    word = mul4[(*memPtr++ >> shift) & ~(-1 << curWidth)];
		    word <<= 16 - (curWidth << 2);
		    for (j = 4; j > 0; j--) *yFB++ = word;
		  }
	        break;
	    case Scale8:
		for (i = height; i > 0; i--)
		  { 
		    word = mul8[(*memPtr++ >> shift) & ~(-1 << curWidth)];
		    word <<= 16 - (curWidth << 3);
		    for (j = 8; j > 0; j--) *yFB++ = word;
		  }
	        break;
	    case Scale16:
		for (i = height; i > 0; i--)
		  { 
		    word = -((*memPtr++ >> shift) & ~(-1 << curWidth));
		    word <<= 16 - (curWidth << 4);
		    for (j = 16; j > 0; j--) *yFB++ = word;
		  }
	        break;
	    case Scale8+ScaleFramed:
		*yFB++ = -1;
		for (i = height; i > 0; i--)
		  { 
		    word = (*memPtr++ >> shift) & ~(-1 << curWidth);
		    word = (mul8[word] & 0x7C7C) | 0x0101;
		    word <<= 16 - (curWidth << 3);
		    *yFB++ = 0x0101;
		    for (j = 5; j > 0; j--) *yFB++ = word;
		    *yFB++ = 0x0101; *yFB++ = -1;
		  }
		yFB--;
		break;
	    case Scale16+ScaleFramed:
		*yFB++ = -1;
		for (i = height; i > 0; i--)
		  { 
		    word = -((*memPtr++ >> shift) & 1);
		    word = (word & 0x7FFC) | 1;
		    word <<= 16 - (curWidth << 4);
		    *yFB++ = 1;
		    for (j = 13; j > 0; j--) *yFB++ = word;
		    *yFB++ = 1; *yFB++ = -1;
		  }
		yFB--;
		break;
	}
	x += curWidth << scale;
	moreWidth -= curWidth;
	curOffset += curWidth;
	yFB -= height << scale;
	if (curOffset >= 16) {curOffset = 0; colTop += in->stride;}
      }
  }
