#include "bitptr.h"
struct BitPtr BitPtr;

/* SetBitPtr_Sun100(p, r, x, y)
 * Version of SetBitPtr for Sun-100 framebuffer (by 16-bit collumns)
 * Set p to point to the y'th row and x'th column of r.
 * r->origin[*] is ignored.
 */

SetBitPtr_Sun1(p, r, x, y)
    register struct BitPtr *p;
    register CharPrefix *r;
  { register bit = x + BitOffset(r);
    p->x = x;
    p->y = y;
    p->r = r;
    p->mask = BitWordOnes >> (bit & (BitWordLen-1));
    p->ptr = (BitWord*)r[-1].start + y;
    bit >>= BitWordLog;
    if (bit != 0) p->ptr += bit * r[-1].stride;
  }
