/*
 * gxprobe.c
 *
 * defines: GXProbe();
 * Locate the first available framebuffer; return its address,
 * or zero if none found.
 *
 * Jeffrey Mogul	Stanford	8 April 1982
 */

#include <framebuf.h>

#define	GXSize	(GXUnit1Base - GXUnit0Base)

GXProbe()
{
	int gxadr;

	/* start at GXDefaultBase and work DOWN to GXUnit0Base */
	for (gxadr = GXDefaultBase; gxadr >= GXUnit0Base; gxadr -= GXSize) {
	    if (ProbeAddress(gxadr))	/* found it */
	    	return(gxadr);
	}

	/* didn' t find it */
	return(0);
}
