/* DrawString - write a text string into the Sun FrameBuffer.
 * Dec 1982. Per Bothner
 * BUGS:
 * - It's unclear if clipping in very thin regions will work.
 */

#include <rasterops.h>
#include <Vfont.h>
#include <fonttable.h>
#include <text.h>
#include <m68000.h>
#include <framebuf.h>
FontEntry *LookupFont();

short frontOnes[32] =
  {
         0, 0x8000, 0xC000, 0xE000, 0xF000, 0xF800, 0xFC00, 0xFE00,
    0xFF00, 0xFF80, 0xFFC0, 0xFFE0, 0xFFF0, 0xFFF8, 0xFFFC, 0xFFFE,
    0xFFFF, 0x7FFF, 0x3FFF, 0x1FFF,  0xFFF,  0x7FF,  0x3FF,  0x1FF,
      0xFF,   0x7F,   0x3F,   0x1F,    0xF,    0x7,    0x3,    0x1
  };

enum TextRetCode
WriteText_Sun100 (str,n,x,y,codes,bBox)
    char *str;			/* string to be drawn */
    int n;			/* maximum number of characters to draw */
    int x,y;			/* starting position. (0,0) is top left of screen. */
    FontCodes codes;		/* font, function to use and other codes */
    struct fb_raster *bBox;	/* Bounding box */
  {
    register Vfont *font;					   /* a5 */
    register short i;						   /* d7 */
    register short *regGXBase = (short *)GXBase;		   /* a4 */
#define GXBase ((char *)regGXBase)
#define xFB (regGXBase+x)
    register short *yFB = (short *)(GXBase+(GXupdate|GXselectY|GXsource)); /* a3 */
    register VRaster *raster;					   /* a2 */
    register short offset, height;                /* d6, d5 */
    register clipTop;        /* twice the number of scan-lines to clip at top */ /*d4*/
    register unsigned char c;
    int j;
    int width;
    short bBoxRight = bBox->x + bBox->width;
    FontCodes oldcodes;
    short fastAfter = 9999;	/* controls switching from slow to fastLoop */
    FontEntry *fontEntry;

    i = codes.fontNum; call(changeFont);
    i = y - FontPrefixOf(font)->originAll.v;
    yFB += i;
    oldcodes = codes;
    height = FontPrefixOf(font)->bBoxAll.v;
    i -= bBox->y;
    offset = bBox->height - i;
    if (offset <= 0) return(TextRetBelow);
    if (height > offset) height = offset; /* bottom clipping */
    clipTop = 0;
    if (i < 0) /* abs(i) is how much we have to clip at top */
      { i = -i; yFB += i; height -= i; i <<= 1; clipTop = i;}
    if (height <= 0 /* && codes.fixedHeight */ ) return(TextRetAbove);
    if ((width = FontPrefixOf(font)->bBoxAll.h) > 16) goto slowLoop;
    if (height != 16) goto slowLoop; /* !!! */
    fastAfter = 16;
    if ((i = bBox->x) > 16) fastAfter = i;
    fastAfter += width;
   /* the +width is in case of a BS. we could be a little less conservative */
    if (x < fastAfter)
      {	asm(" jra _slowLoop_"); /* goto slowLoop */
/* trick the compiler into not giving any "statement not reached" warnings */
	goto _dummy_; 
      }

  fastLoop:
    while (1)
      {
        if (--n < 0) return(TextRetCount);
        c = *str++;
        GXfunction = codes.function;
	raster = font->c[c];
        if (raster == NULL)
	    if (!execcode()) continue;
        width = raster[-1].bBox.h;
	GXpattern = 0;
        raster = (VRaster *)((char*)raster[-1].start + clipTop);
        i = width;
        GXwidth = i;
        if ((i += x) > bBoxRight)
            if (x >= bBoxRight) return(TextRetRight); /* BS danger ignored */
            else GXwidth = bBoxRight - x;
        *xFB = 0;
	x = i;
/*	*yFB++ = *(u_short*)raster++; */
/*	using: a0,a1,d0-d3,d7,d6 --seems to be very slightly faster:
	asm(" moveml a2@,#/03CF")
	asm(" moveml #/03CF,a3@");
 */
	d7 = (int)yFB;
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
        yFB = (short *)d7;
      }

  slowLoop: asm("_slowLoop_:");
    while (1)
      {
        if (--n < 0) return(TextRetCount);
        c = *str++;
        GXfunction = codes.function;
  	raster = font->c[c];
        if (raster == NULL)
	    if (!execcode()) continue;
        width = raster[-1].bBox.h;
        raster = (VRaster *)((char *)raster[-1].start + clipTop);

	GXpattern = 0;
        c = width;

        do
          {
/**  if (x < 0 || x > 1023) printf("Error:x=%d,w=%d,off=%d!",x,width,offset); */
            if ((i = c) > 16) i = 16;
            GXwidth = i;
            if (x + i > bBoxRight)
                if (x >= bBoxRight) return(TextRetRight);
                else GXwidth = bBoxRight - x;
            if (x < bBox->x)
              {
                if (x + i < bBox->x || x < 0) {x+=i; continue;}
                offset = bBox->x - x; offset = frontOnes[offset];
                d0 = x & 0xF; asm(" rorw d0,d6"); GXpattern = offset;
              }
/*  if (x < 0 || x > 1023) printf("Error:x=%d!",x); */
            *xFB = 0;
	    x+=i;
            i = height;
	    i>>=1;
	    asm(" .word /6402"); /* really bcc .+2 but the assembler is buggy */
	    /* that is: skip following instruction if height even */
	    asm(" movw a2@+,a3@+");
	    /* The following rather clumsy code is for the benefit of the optimizer */
	    goto paintBot;
	    paintTop:
	    /* cc croaks on this: *((long *)yFB)++ = *((long *)raster)++; */
	    asm(" movl a2@+,a3@+");
	    paintBot: if (--i != -1) goto paintTop;
            yFB -= height;
          } while (c > 16 &&
            (GXpattern = 0, c-= 16,
	     raster = (VRaster*)((short*)raster + font->g.bBoxAll.v)));
	if (x >= fastAfter) goto fastLoop;
      }

asm("execcode:")
    /* execcode acts like a subroutine, however no parameters are passed,
     * and all registers are preserved.
     * on return, d0 contains 1 if c should be drawn, 0 if should go to top of loop.
     */
_dummy_: /* to avoid "statement not reached" warnings */
    if (c > 0x80 && codes.inverseIfHigh)
      {
	c&=0x7F;
	GXfunction = (GXcopy & 0x0F) | (GXnoop & 0xF0);
	raster = font->c[c];
      }
    else
    switch (c)
      {
	case 128: c = '\0'; raster = font->c[0]; break;
        case STOP: return(TextRetStop);
        case FILL: case After1ByteArg:
	    returns(0);
	case SmallHskip:
            if (--n < 0) return(TextRetCount);
            i = (char)(*str++); /* sign extend */
	    /* if (codes.mustClearBackground && i > 0) should clear...*/
            x += i;
            returns(0);
        case LF:
            if (codes.mustClearBackground)
              {
                if ((i = bBox->x - x) > 0) x = bBox->x;
                width = bBoxRight - x; GXpattern = 0;
                while (width > 0)
                  {
                    GXwidth = i = (width > 16 ? 16 : width);
		    *xFB = 0; x += i; width -= 16;
                    offset = 0;
                    for (i = height; i > 0; i--) *yFB++ = offset;
                    yFB -= height;
                  }
              }
            return(TextRetLine);
        case BegInverse:
            if (codes.backgroundColor == oldcodes.backgroundColor)
              {
                codes.backgroundColor = !codes.backgroundColor;
                codes.function = (GXcopy & 0x0F) | (GXnoop & 0xF0);
                GXfunction = codes.function;
              }
            returns(0);
        case EndInverse:
            GXfunction = codes.function = oldcodes.function;
            codes.backgroundColor = oldcodes.backgroundColor;
            returns(0);
        case BegItalic:
            i = fontEntry->italic;
            if (i != NOFONT && i > codes.fontNum)
	        goto changeFont;
	    returns(0);
        case EndItalic:
            i = fontEntry->italic;
            if (i != NOFONT && i < codes.fontNum)
	        goto changeFont;
	    returns(0);
        case BegBold:
            i = fontEntry->bold;
            if (i != NOFONT && i > codes.fontNum)
	        goto changeFont;
	    returns(0);
        case EndBold: 
            i = fontEntry->bold;
            if (i != NOFONT && i < codes.fontNum)
	        goto changeFont;
	    returns(0);
	case FONTn:
            if (--n < 0) return(TextRetCount);
            i = *str++;
	    goto changeFont;
        case FONT0: case FONT1: case FONT2: case FONT3:
        case FONT4: case FONT5: case FONT6: case FONT7:
        case FONT8: case FONT9: case FONT10: case FONT11:
        case FONT12: case FONT13: case FONT14: case FONT15:
	    i = c & 0xF;
	    goto changeFont;
        case QUOTE:
            if (--n < 0) return(TextRetCount);
            c = *str++;
	    /* ... then fall through to ... */
        default:
            returns(0);
    };
    if (!raster) returns(0);
    returns(1);

  changeFont:
  asm("changeFont:");
/* change to font number 'i' */
    if (!(fontEntry = LookupFont(i))) goto badFont;
    font = (Vfont*)fontEntry->font;
    codes.fontNum = fontEntry->number;
    returns(0);
  badFont:
    printf("!!! Trying to use bad font number: %d !!!\n", i);
    returns(TextRetError);
  }    

