@Chapter(Overview)
The graphics library for the SUN workstation constitutes an effort to 
provide 
a set of general purpose, low-level routines for use with the SUN graphics
system (framebuffer).
The intention is to group routines relevant to a
particular type of graphical object or representation into a module, and
then to use routines from these modules as needed to develop
higher level packages.
It is hoped that most users will interface to a higher-level
package, such as the SUN Virtual Graphics Termimal Service,
so only implementors need to be concerned with the details of
this level.

@Section(Design Focus)
The design focus for the package discussed in this manual
is on the lowest layer of
abstraction between the SUN hardware and any higher level graphics packages 
intended to run on the SUN.  
The general aspiration for this layer is to provide an
object-oriented approach to graphics.
That is, provide the graphics user with
a set of routines (a module) which allow him to deal with each class of
graphical objects.

@begin(Figure)
@PressPicture( Height = "3.8 Inches", File = "SoftHier.press" )
@caption(Heirarchy of Graphics Software on the SUN Workstation)
@Tag(Softhier)
@End(Figure)

Two classes of graphical objects of obvious utility are Rasters and Lines.
With Rasters, we can handle anything representable with
rectangular regions.
Fixed width fonts are one fairly direct application example of this.
Lines give us the ability to
deal with traditional ``vector'' based representations;
for example, a two dimensional 
application like SUDS, or for
wire-frame representations of three dimensional objects when used with a
package of three dimensional transforms.

Aspirations for the future include polygon filling routines (perhaps to be
based on the raster ops presently existing), and curve generators (to
supplement the line drawing primitives).

Individuals contemplating additions to this package should 
concur with the ideology of an object-oriented "layer".
This will hopefully
promote the object-oriented building block approach to graphics applications
software on SUN.
Additionally, the implementor of routines which are 
intimately tied
to the framebuffer must be familiar with the SUN hardware.
"The SUN User's Guide" compiled by Bill Nowicki contains a chapter
on programming the SUN graphics board, and Andy Bechtolscheim
has a separate manual on it.

@Section(Graphics Package Routines)

Since the SUN graphics system is a framebuffer (i.e. a bit mapped
graphical memory), substantial consideration was given to the idea of
logical operations on bitmaps, (called RasterOps
in Newman and Sproull's Principles of Interactive Computer Graphics),
and rapid transfer of bit maps, (Bit Blt) as applied in various systems with 
bit-mapped graphics hardware (in particular, the Xerox Alto).

Presently the package includes a set of several RasterOp routines
which allow the rapid transfer of rasters (rectangular bit mapped regions)
combined with a raster operation. 
These routines move rasters between the processor's memory and framebuffer, 
from one place to
another within the frame buffer, update rasters
in place  in the framebuffer. 

A Bresenham Algorithm Vector drawing primtive is presently the sole basis of
line-drawing applications@foot[One should remember, however that the raster
operation is @b[@i[totally]] general, since we may have rasters of one
pixel, and thus implement anything which a bit-mapped device allows.  It is 
only fot performance reasons and
to save re-inventing the wheel for each application
that modules of
routines dealing with other graphical objects are written.].

All the primitives are implemented in a way which makes them as 
speed-efficient as possible considering the nature of the SUN processor,
and the frame buffer.

@Comment(Subsequent design should incorporate Vaughan's contour routine,
          and potentially his incremental algorithm for 3d.
	  Ken Brooks also did a bunch of stuff, and Tom Davis did
	  for Yale, and so on)

Please report all bug fixes, suggested improvements, and general comments
on the package and documentation to @t[graphics@@Shasta] via electronic mail.
@b[Please DO NOT] follow the traditional practice of getting interesting
routines from a friend.  
Put them in the library, so we all can benefit from them!

@Section(The Frame Buffer)

    The way to access the framebuffer registers in conjunction with the routines in
this graphics package will be described in further
detail below.
The best way to determine whether to
bother to read this section is to first read the section on the module from
which you intend to use routines, then refer back as necessary (of course 
you can always read it right off and suffer the extra information if it's
unneeded later).


@subsection(The SUN Graphics System Architecture)

    The standard SUN graphics hardware consists of a bit-mapped memory, 
coupled with a raster-function unit capable of performing
bit manipulation functions on the contents of this memory.
The graphical memory is 1 million bits, corresponding to a graphical region of 1024
by 1024 pixels.  Each pixel therefore has 1 bit resolution, or a grey scale 
consisting of black/white (i.e. ON/OFF).  In the future several framebuffers
may be used in conjunction to provide enhanced grey-scale and/or color.

Although there are 1024 by 1024 pixels stored in the memory,
only about 800 by 1000 of these are actually
displayed on the video monitor.
There are two modes of viewing, as illustrated in Figure @ref(VwModes).
In "portrait mode" the visible region is 800
pixels wide by 1024 high (with a 224 by 1024 pixel "vertical block" chopped off
the right hand side); 
in "landscape mode" the visible region is 1024 wide by 800 high
(with a 1024 by 224 pixel "horizontal block" chopped off the bottom).

@Begin(Figure)
@PressPicture( Height = "5.4 Inches", File = "ViewMode.press" )
@Caption(The Viewing Mode Alternatives for the Framebuffer)
@Tag(VwModes)
@End(Figure)

  The pixels not displayed (1024 by 224) in either mode, are still accessible,
and may be used as a cache to store bit maps which are not visible.
In most applications, however, the display is treated as 1024 square
and the wasted space ignored to simplify software.

@define(BC,Font SmallBodyFont, FaceCode B, Capitalized)
@string(#xy="@BC[<X,Y>]")
@string(#x="@BC[X]")
@string(#y="@BC[Y]")
@string(#xyw="@BC[<(X+Width-1),Y>]")

    The framebuffer allows pixel addressing via @value(#xy) coordinates, with
the upper left hand corner of the display corresponding to @BC[<0,0>].
Positive @value(#x) displacement is to the right, positive @value(#y) 
displacement is down.

The framebuffer allows the
access of up to sixteen horizontally adjacent pixels on each read-modify-write
cycle (one access to the graphical memory). 
This assists the updating
of many pixels at once, yielding increased bandwidth when a group of pixels 
are operated on by the same function (or raster operation).  The number
of pixels accessed in a given cycle is determined by the setting of the
@BC[Width] register in the framebuffer, which may take a value of 1 through 
16.

    The "Raster Operation", or graphical function, which updates locations 
(pixels) in the framebuffer, is specified by setting the 
framebuffer's @BC[Function] register.
The function specifies the graphical operation which
will be used to update the pixels from @value(#xy) through @value(#xyw) on 
this
access (read or write cycle) of the graphical memory.  The function has
three operands:  The value(s) of the pixel(s) being accessed, and the
corresponding bit(s) of two framebuffer registers: @BC[Source] register and
@BC[Pattern] register.  
The Raster-Operation is a function which 
maps the value of these three bits into the pixel(s) being accessed.  
That is:

@ProgramExample[
pixel-value = Function( @BC[Source]@-[i], @BC[pattern]@-[i], pixel-value)]

To simplify the discussion, consider the access of a single pixel for the time
being (@BC[Width] would be set to 1 for a single pixel access),
and assume that @BC[Source] and @BC[Pattern] are loaded appropriately.
Since there are three bits on which the function operates, there
are 2@+[2@+[3]] 
functions (mappings) that we may choose to apply to these three operands
(which give boolean result).  
That is, there are 256 different
boolean mappings of three boolean arguments.
These functions can be enumerated as in Figure @ref(Functs).
To convert the function to a code, look at the table from the
right side, so that the top bit is lowest order, and the bottom
bit is the highest order.

@Begin(Figure)
@PressPicture( Height = "2.7 Inches", File = "Functs.press" )
@Caption(Enumeration of "Raster Op" Functions)
@tag(Functs)
@End(Figure)

    An example of one function we could perform is that which takes the 
current pixel-value, @b[AND]'s it with the @BC[Source] register bit,
and @b[OR]'s this with the @BC[Pattern] register bit.
We want ones in the last five rows of the table, resulting in
a bit pattern of @t[1111 1000], or @t[F8] in hex.
The result of a
Raster-Operation (application of the graphical function) always goes into
the pixel in the graphical memory being accessed, so the new pixel-value 
would be the result of this function.

    The general case (width greater than
one pixel) simply applies the same function (boolean mapping) to
corresponding bits of the @BC[Source] register, @BC[Pattern] register, and pixel 
in the 
framebuffer.  The result of the function is given to the pixel in the
framebuffer operated on in that mapping.  To clarify
this, think of the framebuffer pixels operated on ( @value(#xy) through
 @value(#xyw) ), as a conceptual
third register "@b[Destination]" (of up to 16 bits) which provides the 
pixels corresponding to bits in the @BC[Pattern] and @BC[source] registers.
This is similar to the @b[mapcar]
function in @b[LISP] -- that is, the mapping of one function to
several sets of arguments.   "Destination" pixels
in the graphical memory are both one of the three arguments to the function,
@i[and] take the function's result.

    As yet, we have not specified how the @BC[Source] and @BC[Pattern]
register work into this scheme, or how @value(#xy) (the pixel address for the
current cycle) is specified, but this will become clearer as we proceed.
Let's summarize before proceeding. The framebuffer hardware has
the following registers pertinent to its operation:

@begin(itemize)

@b[The @BC[Width] register] -- Specifies the number of pixels to access on 
this cycle (one to sixteen).  This allows us to refer to the pixels 
from @value(#xy) through @value(#xyw), where @value(#xy) is the pixel address
referred to for this access.

@b[The @BC[Source] register] -- Contains one of three operands
of the currently selected function (raster operation).
On read references this value can be set from the framebuffer, and on
write references it is set from the processor's memory.
This register is shifted to align the high order bit with the specified
@value(#xy) coordinate.

@b[The @BC[Pattern] (formerly called @BC[Mask]) register] -- 
Contains the second of the three 
operands operated on under the present function.
This is @b(not) bit aligned with the source or destination.

@b[The @BC[Function] register] -- Specifies the raster operation to occur on 
this access.  
It may be any of the 256 possible possible functions.

The Conceptual @b["Destination"] -- The pixels at @value(#xy) through
@value(#xyw), are the third operand of the present raster function.  
They also receive the result of this function.

@end(itemize)

    Now, how do the @BC[Source] and @BC[Pattern] register
fit into this, and how are pixel-addresses specified?  
Notice that we cannot
directly change the graphical memory, but that it is a
Raster-Operation (the result of the present
function) which changes these locations.
Thus it is by moving data into the
@BC[Source] and or @BC[Pattern] registers, prescribing one of
the 256 possible Raster-Operations in the @BC[function] register, and
then @i[performing] the RasterOp on an access to the framebuffer, 
that we cause the pixels referenced (by @value(#xy)) to be changed.
The framebuffer has been cleverly designed to overlap some of
these operations, resulting in higher performance than other
bit-mapped systems.

@subsection(Accessing the Framebuffer Registers)

The @BC[Source] and @BC[Pattern]
registers (like the @BC[Function] and @BC[Width] registers) are
accessible (much like other MULTIBUS@foot[Multibus is a trademark of Intel
Corporation] locations) from the processor through the memory map.
That is, they may receive data coming from the
processor simply by writing to a certain address in the space occupied by the
framebuffer.  
Users of this package should access them
via names defined in one of the "header" files included with an application
program which uses the routines (presently @t[framebuf.h]).

  These names are (at least for the present):
@begin(description)
@t[GXfunction]@\This location sets the function register.
@t[GXfunction] should be set before almost every graphics primitive.

@t(GXpattern)@\Writing to this location sets the @bc[pattern] register.
Many of the function settings ignore the @bc[pattern] register;
it only has to be set when you use it.

@t(GXwidth)@\This is set to a value from 1 to 16, the number
of adjacent pixels to be operated on at any one time.
Most graphics primitives will set this register, except
the @t[Line] operations.

@t(GXsetSource)@\This location sets the @bc[source] register.
The @bc[source] register can also be set during the course of the RasterOp,
as described in the @t[Put] and @t[Copy] primitives described in the next chapter.
@end(description)

    From the standpoint of use of these routines, it will not be necessary
for applications programs to directly affect the @BC[X] or @BC[Y]
pixel-address registers which the framebuffer hardware also contains.  The
routines in the graphics package accept @BC[X] and @BC[Y]
arguments which indicate a location in the graphical memory,
and deal with the framebuffer appropriately to carry out
the required operation.  It will only be necessary for the user to specify
@BC[function], @BC[source] and/or @BC[pattern] register contents.

There are some commonly used function codes defined in @t[framebuf.h],
so you can use more meaningful names, as described below:
@Begin(description)
@t[GXnoop]@\No operation.
The destination is replaced with the old destination.
@bc[Source] and @bc[pattern] are ignored.

@t[GXinvert]@\Ones in the destination become zeros, and vice versa.
@bc[Source] and @bc[pattern] are ignored.

@t[GXcopy]@\The destination is replaced with the @bc[source].
Current value of destination and @bc[pattern] are ignored.

@t[GXcopyInverted]@\The destination is replaced with the inversion
of the @bc[source].
Current value of destination and @bc[pattern] are ignored.

@t[GXclear]@\The destination is cleared to all zeros.
All register values are ignored.

@t[GXset]@\The destination is set to all ones.
All register values are ignored.

@t[GXpaint]@\The destination becomes a bit-by-bit inclusive @b[or] of the
@bc[source] and current destination.
Used when drawing possibly overlapping objects which should not
destroy what is underneath them.
The @bc[pattern] is ignored.

@t[GXpaintInverted]@\The destination becomes a bit-by-bit inclusive @b[or]
of the inversion of the @bc[source] and the destination.
The @bc[pattern] is ignored.

@t[GXand]@\The destination is set to the bit-by-bit @b[and] of the
@bc[source] and the destination.
That is, zero bits in the @bc[source] will cause corresponding bits
to be cleared in the destination.
The @bc[pattern] is ignored.

@t[GXxor]@\The destination is set to the bit-by-bit exclusive or of the
@bc[source] and the destination.
That is, zero bits in the @bc[source] will cause corresponding bits
to be inverted in the destination.
The @bc[pattern] is ignored.

@t[GXcopyPattern]@\The @bc[pattern] register is copied into
the destination.
The @bc[source] register is ignored.

@t[GXpaintPattern]@\The @bc[pattern] register is inclusive
@b[or]ed into the destination.
The @bc[source] register is ignored.

@t[GXinvertPattern]@\The @bc[pattern] register is exclusive
@b[or]ed into the destination.
That is, the destination is inverted if the corresponding 
@bc[pattern] bits are one.
The @bc[source] register is ignored.

@t[GXandPattern]@\The @bc[pattern] register is inclusive
@b[and]ed into the destination.
This has the effect of turning black any bits set to zero
in the @bc[pattern] register, so is used to paint black patterns
on white backgrounds.
The @bc[source] register is ignored.
@end(description)

	The manner of actually specifying the @BC[X] and @BC[Y] address
in the framebuffer, and which of
the registers is to receive the data
coming from the processor, is done by a scheme which decodes the address
bus whenever a reference is made to the region of the address space that the 
framebuffer occupies.
If you really want the nasty details of this,
a nice diagram of this decoding scheme is to be found in Bill
Nowicki's "Sun User's Guide" in the Graphics chapter.

    For users of the routines in the graphics package described in this
document, it will not be necessary to have intimate familiarity with the
details of the framebuffer's operation.  However, certain modules (the 
RasterOps for example) require a certain knowlede of 
some of the framebuffer registers.

