/* Some support routines for working on bitmaps (MemRaster's)
 * Per Bothner, March 1983
 */
#include <bitmaps.h>
#include <sfont.h>
#include <rasterops.h>
#include <framebuf.h>

MemRaster WholeFB = {800, 1024, 0, IsFbRaster+InverseRaster}; /* in landscape mode */
MemRaster EmpRaster = {0, 0, 0, IsNullRaster};
MemRaster InvEmpRaster = {0, 0, 0, IsNullRaster+InverseRaster};
MemRaster *
SimpleToGenRaster(out,in)
/* convert simple mem_raster to more general Memraster */
  register MemRaster *out;
  register struct mem_raster *in;
  {
    out->where = MemoryRaster;
    out->bitOffset = 0;
    out->height = in->height;
    out->stride = in->height;
    out->width = in->width;
    out->start = (u_short*)in->start;
    return(out);
  }

MemRaster *
GetHeadRaster(in)
  register MemRaster *in;
  { register MemRaster *r;
    if (!(in->where & LinkedRaster)) return(0);
    r = in;
    while (!(r->where & HeadRaster))
      {
	r = r->next;
	if (!r) return(0);
	if (r == in) return(0);
      }
    return(r);
  }


FreeRaster(in)
  /* free the raster pointed to by 'in', but not the MemRaster structure itself */
  register MemRaster *in;
  { register MemRaster *r; /* raster before 'in' in list */
    if (!(in->where & MemoryRaster) || !in->start) return;
    if (!(in->where & LinkedRaster)) {free(in->start); in->start = 0; return;}
    for (r = in->next; r->next != in; r = r->next) {}
    /* in == r->next */
    if (in == r) {/* singleton list */ free(in->start); in->start = 0; return;}
    if (!(in->where & HeadRaster))
      {
        r->next = in->next; in->next = 0; in->start = 0;
	if (r->where == HiddenHeadRaster && in->next == r)
	  {free(r->start); free(r);}
	return;
      }
    /* delete a head raster & there exist subrasters => we create a dummy head */
    r->next = (MemRaster *)(malloc(sizeof(MemRaster)));
    r = r->next; *r = *in; r->where = HiddenHeadRaster;
    in->start = 0; in->next = in;
  }
  
ChangeBit(rast, x, y, newval)
  register MemRaster * rast;
  int x, y;
  ChangeBitCode newval;
  { int oldval;
    static char bitTrans[2][4] = {{0, 1, 1, 0}, {0, 1, 0, 1}};
    if (rast->where == IsNullRaster) return(-1);
    if (x < 0 || y < 0 || x >= rast->width || y >= rast->height) return(-1);
    if (rast->where == IsFbRaster)
      {
	register short *yFB = GenToFbRaster(rast)->y + y +
	    ((short *) GXBase+(GXselectY|GXsource|GXupdate));
	/* ... not implemented ... !!! */
	return oldval;
      }
      { register u_short *p = rast->start + y;
	register bit = rast->bitOffset + x;
	register mask;
	p += (bit >> 4) * rast->stride;
	bit &= 0xF;
	mask = 0x8000 >> bit;
	oldval = *p & mask ? 1 : 0;
	*p = (*p & ~mask) | (mask & -bitTrans[oldval][(int)newval]);
      }
    return oldval;
  }

MemRaster *
FontRaster(out,font,c)
/* return the raster of character 'c' in font 'font' */
  register MemRaster *out;
  register Sfont *font;
  unsigned char c;
  {
    if (c < font->minChar || c > font->maxChar)
        {if (out) out->where = 0; return(0);}
    if (!out) out = (MemRaster *)(malloc(sizeof(MemRaster)));
    c -= font->minChar;
    out->where = MemoryRaster;
    out->bitOffset = font->widths[c].bit;
    out->width = font->widths[c].width;
    out->stride = out->height = font->height;
    out->start = (u_short *)((char *)font + font->widths[c].word);
    return(out);
  }
