/* DrawString - write a text string into the Sun FrameBuffer.
 * Dec 1982. Per Bothner
 * BUGS:
 * - It's unclear if clipping in very thin regions will work.
 */

#include <rasterops.h>
#include <sfont.h>
#include <text.h>
#include <m68000.h>
FontEntry *LookupFont();

short frontOnes[32] =
  {
         0, 0x8000, 0xC000, 0xE000, 0xF000, 0xF800, 0xFC00, 0xFE00,
    0xFF00, 0xFF80, 0xFFC0, 0xFFE0, 0xFFF0, 0xFFF8, 0xFFFC, 0xFFFE,
    0xFFFF, 0x7FFF, 0x3FFF, 0x1FFF,  0xFFF,  0x7FF,  0x3FF,  0x1FF,
      0xFF,   0x7F,   0x3F,   0x1F,    0xF,    0x7,    0x3,    0x1
  };

enum TextRetCode
WriteText (str,n,x,y,codes,bBox)
    char *str;			/* string to be drawn */
    int n;			/* maximum number of characters to draw */
    int x,y;			/* starting position. (0,0) is top left of screen. */
    FontCodes codes;		/* font, function to use and other codes */
    struct fb_raster *bBox;	/* Bounding box */
  {
    register Sfont *font;					   /* a5 */
    register short i;						   /* d7 */
    register short *regGXBase = (short *)GXBase;		   /* a4 */
#define GXBase ((char *)regGXBase)
#define xFB (regGXBase+x)
    register short *yFB = (short *)(GXBase+(GXupdate|GXselectY|GXsource)); /* a3 */
    register short *pMap;					   /* a2 */
    register short offset, height;                /* d6, d5 */
    register clipTop;        /* twice the number of scan-lines to clip at top */ /*d4*/
    register unsigned char c;
    int j;
    int width;
    short bBoxRight = bBox->x + bBox->width;
    FontCodes oldcodes;
    short fastAfter = 9999;	/* controls switching from slow to fastLoop */
    FontEntry *fontEntry;

    i = codes.fontNum; call(changeFont);
    i = y - font->height + font->descent;
    yFB += i;
    oldcodes = codes;
    height = font->height;
    i -= bBox->y;
    offset = bBox->height - i;
    if (offset <= 0) return(TextRetBelow);
    if (height > offset) height = offset; /* bottom clipping */
    clipTop = 0;
    if (i < 0) /* abs(i) is how much we have to clip at top */
      { i = -i; yFB += i; height -= i; i <<= 1; clipTop = i;}
    if (height <= 0 /* && codes.fixedHeight */ ) return(TextRetAbove);
    if ((width = font->maxWidth) > 16) goto slowLoop;
    if (height != 16) goto slowLoop; /* !!! */
    fastAfter = 16;
    if ((i = bBox->x) > 16) fastAfter = i;
    fastAfter += width;
   /* the +width is in case of a BS. we could be a little less conservative */
    if (x < fastAfter) goto slowLoop;

  fastLoop:
    while (1)
      {
        if (--n < 0) return(TextRetCount);
        c = *str++;
        GXfunction = codes.function;
        if (c < MINCHAR || c > MAXCHAR) /* control character */
	    if (!execcode()) continue;
        c -= font->minChar;
	pMap = (short *)(font->widths + c);
        offset = ((CharInfo *)pMap)->bit;
        width = ((CharInfo *)pMap)->width;
        x -= offset;
#if 1	/* equivalent pieces of code */
        i = frontOnes[offset];
	d0 = x & 0xF;
        asm (" rorw d0,d7");
#else
	a0= (int *)(frontOnes+(x & 0xF));
	i = *(short *)a0;
	d0 = offset;
	asm(" aslw #1,d0");
	asm(" addw d0,a0");
	i ^= *(short *)a0;
#endif
	GXpattern = i;
        pMap = (short *)(((CharInfo *)pMap)->word + clipTop + (char *)font);
        i = width + offset;
        GXwidth = i;
        if ((i += x) > bBoxRight)
            if (x >= bBoxRight) return(TextRetRight); /* BS danger ignored */
            else GXwidth = bBoxRight - x;
        *xFB = 0;
	x = i;
/*	*yFB++ = *pMap++; */
/*	using: a0,a1,d0-d3,d7,d6 --seems to be very slightly faster:
	asm(" moveml a2@,#/03CF")
	asm(" moveml #/03CF,a3@");
 */
	d7 = (int)yFB;
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
	asm(" movl a2@+,a3@+");
        yFB = (short *)d7;
      }

  slowLoop:
    while (1)
      {
        if (--n < 0) return(TextRetCount);
        c = *str++;
        GXfunction = codes.function;
        if (c < MINCHAR || c > MAXCHAR) /* control character */
	    if (!execcode()) continue;
        c -= font->minChar;
  	pMap = (short *)(font->widths + c);
        offset = ((CharInfo *)pMap)->bit;
        width = ((CharInfo *)pMap)->width;
        pMap = (short *)(((CharInfo *)pMap)->word + clipTop + (char *)font);

	/* The bitmap of a character need not be aligned on a word boundary.
	 * To avoid shifting the characters left (as assumed by the FB),
	 * we do a hack by moving left and masking out the intervening garbage.
	 * Unfortunately, we can't move left beyond pixel 0, so at the
	 * extreme left we have to do the shifting ourselves.
	 */
        x -= offset;
	if (x < 0)
	  { /* Here we shift the character's bitmap "by hand" */
            x += offset; /* to cancel previous subtraction */
	    i = 16 - offset; if (i > width) i = width; GXwidth = i;
            GXpattern = 0;
            if (x < bBox->x)
              {
                if (x + i < bBox->x) {x+=i; width -= i; goto endShiftSegment;}
                offset += bBox->x - x; width -= bBox->x - x; x = bBox->x;
		GXwidth = bBox->x - x;
              }
	    if (x + i > bBoxRight)
                if (x >= bBoxRight) return(TextRetRight);
                else GXwidth = bBoxRight - x;
	    *xFB = 0;
	    x += i; width -= i;
	    for (i = height; i > 0; i--) *yFB++ = *pMap++ << offset;
            yFB -= height;
	  endShiftSegment:
	    if (width <= 0) goto slowLoop;
            offset = 0; i = c = width;
	    pMap += font->height - height;
	  }
	else
	  {
            i = frontOnes[offset];
            d0 = x & 0xF; asm (" rorw d0,d7"); GXpattern = i;
            c = i = width + offset;
	  }

        do
          {
/**  if (x < 0 || x > 1023) printf("Error:x=%d,w=%d,off=%d!",x,width,offset); */
            if (i > 16) i = 16;
            GXwidth = i;
            if (x + i > bBoxRight)
                if (x + offset >= bBoxRight) return(TextRetRight);
                else GXwidth = bBoxRight - x;
            if (x + offset < bBox->x)
              {
                if (x + i < bBox->x) {x+=i; continue;}
                offset = bBox->x - x; offset = frontOnes[offset];
                d0 = x & 0xF; asm(" rorw d0,d6"); GXpattern = offset;
              }
/*  if (x < 0 || x > 1023) printf("Error:x=%d!",x); */
            *xFB = 0;
	    x+=i;
            i = height;
	    i>>=1;
	    asm(" .word /6402"); /* really bcc .+2, but the assembler is buggy */
	    /* that is skip following instruction if height even */
	    *yFB++ = *pMap++;
	    /* The following rather clumsy code is for the benefit of the optimizer */
	    goto paintBot;
	    paintTop:
	    /* cc croaks on this: *((long *)yFB)++ = *((long *)pMap)++; */
	    asm(" movl a2@+,a3@+");
	    paintBot: if (--i != -1) goto paintTop;
            yFB -= height;
          } while (c > 16 &&
            (offset = 0, GXpattern = 0, pMap += font->height - height,
	     c -= 16, i = c));
	if (x >= fastAfter) goto fastLoop;
      }

asm("execcode:")
    /* execcode acts like a subroutine, however no parameters are passed,
     * and all registers are preserved.
     * on return, d0 contains 1 if c should be drawn, 0 if should go to top of loop.
     */
    if (c > 0x80 && codes.inverseIfHigh)
	{c&=0x7F; GXfunction = (GXcopy & 0x0F) | (GXnoop & 0xF0); returns(1);}
    switch (c)
      {
        case STOP: return(TextRetStop);
        case FILL: case After1ByteArg:
	    returns(0);
        case BS:
            if (n && (*str != '_' || !UnderlineCode(font)))
                i = *str;
            else i = str[-2];
            if (i < MINCHAR || i > MAXCHAR) width = font->maxWidth;
            else {
                width = font->widths[i-font->minChar].width;
                if (width <= 0) width = font->maxWidth;
            }
            x -= width;
            if (*str == '_' && UnderlineCode(font) && n) {
                /* compiler bug: i = y + font->underlineTop; */
                asm(" movb a5@(10),d7");
                asm(" asrb #3,d7"); /* compiler generates lsr instead */
                asm(" extw d7");
                i += y;
                offset = font->underlineThickness;
		/* sigh: see if we have to vertically clip the underbar */
                if (i < bBox->y) { offset -= bBox->y - i; i = bBox->y; }
                if (offset < 0) offset = 0;
                if (i + offset > bBox->y + bBox->height)
                    offset -= bBox->y + bBox->height + i;
                if (offset <= 0) { x+=width; str++; --n; returns(0); }
                pMap = i
                    + (short *) (GXBase+(GXupdate|GXselectY|GXsource));
                if ((j = bBox->x - x) > 0) /* Clip left*/
                    {x += j; width -= j;}
                j = x + width;
                if ((i = j - bBoxRight) > 0) width -= i; /*Clip right*/
                GXpattern = 0;
                while (width > 0)
                  {
                    GXwidth = i = (width > 16 ? 16 : width);
		    *xFB = 0; x += i; width -= 16;
                    for (i = offset; --i >= 0; )
                        *pMap++ = -1;
                    pMap -= offset;
                  }
                x = j; str++; --n; returns(0);
            }
            if (codes.mustClearBackground && codes.backgroundColor)
              { 
                WriteText(str, 1, x, y,
                    TextStdPaint+codes.fontNum, bBox);
                x += width; str++; --n; GXfunction = codes.function;
                returns(0);
              }
            returns(0);
        case TAB:
            if (codes.mustClearBackground)
                WriteText("        ", 8, x, y, codes, bBox);
            i = 8 * font->widths[' ' - font->minChar].width;
            x += i;
            returns(0);
	case SmallHskip:
            if (--n < 0) return(TextRetCount);
            i = (char)(*str++); /* sign extend */
	    /* if (codes.mustClearBackground && i > 0) should clear...*/
            x += i;
            returns(0);
        case LF:
            if (codes.mustClearBackground)
              {
                if ((i = bBox->x - x) > 0) x = bBox->x;
                width = bBoxRight - x; GXpattern = 0;
                while (width > 0)
                  {
                    GXwidth = i = (width > 16 ? 16 : width);
		    *xFB = 0; x += i; width -= 16;
                    offset = 0;
                    for (i = height; i > 0; i--) *yFB++ = offset;
                    yFB -= height;
                  }
              }
            return(TextRetLine);
        case BegInverse:
            if (codes.backgroundColor == oldcodes.backgroundColor)
              {
                codes.backgroundColor = !codes.backgroundColor;
                codes.function = (GXcopy & 0x0F) | (GXnoop & 0xF0);
                GXfunction = codes.function;
              }
            returns(0);
        case EndInverse:
            GXfunction = codes.function = oldcodes.function;
            codes.backgroundColor = oldcodes.backgroundColor;
            returns(0);
        case BegItalic:
            i = fontEntry->italic;
            if (i != NOFONT && i > codes.fontNum)
	        goto changeFont;
	    returns(0);
        case EndItalic:
            i = fontEntry->italic;
            if (i != NOFONT && i < codes.fontNum)
	        goto changeFont;
	    returns(0);
        case BegBold:
            i = fontEntry->bold;
            if (i != NOFONT && i > codes.fontNum)
	        goto changeFont;
	    returns(0);
        case EndBold: 
            i = fontEntry->bold;
            if (i != NOFONT && i < codes.fontNum)
	        goto changeFont;
	    returns(0);
	case FONTn:
            if (--n < 0) return(TextRetCount);
            i = *str++;
	    goto changeFont;
        case FONT0: case FONT1: case FONT2: case FONT3:
        case FONT4: case FONT5: case FONT6: case FONT7:
        case FONT8: case FONT9: case FONT10: case FONT11:
        case FONT12: case FONT13: case FONT14: case FONT15:
	    i = c & 0xF;
	    goto changeFont;
        case QUOTE:
            if (--n < 0) return(TextRetCount);
            c = *str++;
	    /* ... then fall through to ... */
        default:
            if (c < font->minChar || c > font->maxChar) returns(0) else break;
    };
    returns(1);

  changeFont:
  asm("changeFont:");
/* change to font number 'i' */
    if (!(fontEntry = LookupFont(i))) goto badFont;
    font = fontEntry->font;
    codes.fontNum = fontEntry->number;
    returns(0);
  badFont:
    printf("!!! Trying to use bad font number: %d !!!\n", i);
    returns(TextRetError);
  }    

