/* Calculate bounding box of string */
#include <Vfont.h>
#include <text.h>
#include <rasterops.h>
#define hvTest(coord) \
 { register xy = (cur.coord>>16) - r[-1].origin.coord;\
   if (xy < min.coord) min.coord = xy;	\
   xy += r[-1].bBox.coord;		\
   if (xy > max.coord) max.coord = xy;\
   cur.coord += r[-1].width.coord;	\
  }

TextBBox(str, n, font, pos, bBox, codes)
    unsigned char *str;
    int n;	/* length of 'str' */
    ScaledVector *pos;	/* in: staring pos; out:end pos */
    register Vfont *font;
    register struct fb_raster *bBox;
    FontCodes codes;
#define INF 32767
  {
    ScaledVector cur;
    int xMax = -INF, yMax = -INF;
    int i; Vector min, max;
    min.h = INF; max.h = -INF;
    min.v = INF; max.v = -INF;
    /* !@#$%^&*( compiler bug! */
    cur.v = pos->v;
    cur.h = pos->h;
    for (;;)
      { int ch;
	register VRaster *r;
	if (--n < 0) break;
	ch = *str++;
	r = font->c[ch];
	if (r == NULL)
	  {
	    if (ch > 0x80 && codes.inverseIfHigh)
	       ch &= 0x7F;
	    else if (ch == STOP) break;
	    else
		switch (ch)
		  {
		    case 128: ch = '\0'; break;
		    case FILL: case After1ByteArg:
			continue;
		    case SmallHskip:
			if (--n < 0) return;
			i = (char)(*str++); /* sign extend */
			cur.h += i<<16;
			continue;
		    default:
			continue;
		  };
	    r = font->c[ch];
	    if (r == NULL) continue;
	  }
	hvTest(h); hvTest(v);
      }
    *pos = cur;
    bBox->x = min.h; bBox->y = min.v;
    bBox->width = max.h - min.h; bBox->height = max.v - min.v;
    return;
  }
