/* ReadGenericFont(font, filep, options)
 * Read in a font file in GF format into the font buffer 'font'.
 * 'filep' is position at the beginning of the font file.
 * If TFMwidth != NULL, also fills those in.
 */
#include "stdio.h"
#include <Vfont.h>
#include <gfont.h>
#include <bitptr.h>
#define NoKern
extern VRaster *AllocRaster();

SystemCode
ReadGenericFont(font, fp, options)
    register FILE *fp;
    register Vfont *font;
    int options;	/* currently unused; should be zero */
  { register c;
    int i;
    int gBack, minX, maxX, minY, maxY;

    for (c = 0; c <= 255; c++)
      {
	font->c[c] = 0;
	if ((&font->g)[-1].TFMwidth != 0)
	    (&font->g)[-1].TFMwidth[c] = i;
      }
    if (GetUnsigned1(fp) != pre || GetUnsigned1(fp) != gf_magic)
	return BAD_STATE;
#if 0
    c = GetUnsigned1(fp);
    printf("\n[");
    while (--c >= 0) fputc(fgetc(fp), stdout);
    fputc(']', stdout);
    fflush(stdout);
#endif
    fseek(fp, -1, 2);
    while ((c = GetUnsigned1(fp)) == postfill)
      { fseek(fp, -2, 1); }
    if (c != gf_magic) return BAD_STATE;
    fseek(fp, -5, 1);
    i = GetSigned4(fp); /* address of post command */
    fseek(fp, i, 0);
    if (GetUnsigned1(fp) != post) return BAD_STATE;
    gBack = GetSigned4(fp);
    FontPrefixOf(font)->designSize = GetSigned4(fp);
    GetSigned4(fp); /* checksum */
    FontPrefixOf(font)->resolution.h = GetSigned4(fp);
    FontPrefixOf(font)->resolution.v = GetSigned4(fp);

 /* font bounding box */
    minX = GetSigned4(fp);
    FontPrefixOf(font)->originAll.h = -minX;
    FontPrefixOf(font)->bBoxAll.h = GetSigned4(fp) - minX;
    minY = GetSigned4(fp);
    maxY = GetSigned4(fp) + 1;
    FontPrefixOf(font)->originAll.v = maxY;
    FontPrefixOf(font)->bBoxAll.v = maxY - minY;

    FontPrefixOf(font)->minChar = 255; FontPrefixOf(font)->maxChar = 0;
    while ((i = GetUnsigned1(fp)) == char_loc || i == char_loc0)
      { long savePos, byteWidth; ScaledVector width; Vector bBox, start;
	register CharPrefix *r;
	c = GetUnsigned1(fp);
	if (NEW_GF && i == char_loc0)
	    width.h = GetUnsigned1(fp) << 16;
	else
	    width.h = GetSigned4(fp);
	if (i == char_loc) { width.v = GetSigned4(fp); }
	else width.v = 0;
	i = GetSigned4(fp);	/* TFMwidth */
	if ((&font->g)[-1].TFMwidth != 0)
	    (&font->g)[-1].TFMwidth[c] = i;
        savePos = ftell(fp);	
	fseek(fp, GetSigned4(fp), 0);
	if ((i = SkipToBoc(fp)) == 0) return BAD_STATE;
	if (i == boc)
	  {
	    if (GetSigned4(fp) != c) return BAD_STATE;
	    if (GetSigned4(fp) != -1) return INTERNAL_ERROR;
	    minX = GetSigned4(fp);
	    maxX = GetSigned4(fp);
	    minY = GetSigned4(fp);
	    maxY = GetSigned4(fp);
	  }
	else /* boc1 */
	  {
	    if (GetUnsigned1(fp) != c) return BAD_STATE;
	    i = GetUnsigned1(fp);
	    maxX = GetUnsigned1(fp);
	    minX = maxX - i;
	    i = GetUnsigned1(fp);
	    maxY = GetUnsigned1(fp);
	    minY = maxY - i;
	  }
	maxY++;
	/* Semi-open interval: min{X,Y} <= {x,y} < max{X,Y} */
	bBox.h = maxX-minX;
	bBox.v = maxY-minY;
#if 0
	if (minX > 0 && ((bBox.h+15)>>4) == ((maxX + 1)>>4))
	   { bBox.h += minX; minX = 0; }
	if ((options & NoKern) && width > bBox.h && () == () )
	  { bBox.h = width; }
#endif
	start.h = 0; start.v = 0;
#ifdef MC68000
	if (options & FontSun100)
	  {
	 /* For the sun100 VGTS, all characters must have same height */
	    i = FontPrefixOf(font)->originAll.v;
	    start.v = i - maxY;
	    if (start.v < 0) start.v = 0; /* paranoia in case of bad fonts */
	    maxY = i;
	    if (FontPrefixOf(font)->bBoxAll.v > bBox.v) /* paranoia again */
		bBox.v = FontPrefixOf(font)->bBoxAll.v;
	 /* sun100Vgts text routine only uses bBox.h as width */
	    if (minX > 0) { bBox.h += minX; start.h = minX; minX = 0; }
	    i = width.h >> 16;
	    if (i > bBox.h) bBox.h = i;
	  }
#endif
	if (bBox.h <= 0) { bBox.v = 0; maxY = 0; }
	byteWidth = 2 * ((bBox.h + 15) >> 4);
	r = AllocRaster(bBox.v * byteWidth);
	if (r == AllocFailure) return NO_MEMORY;
	r[-1].bBox = bBox;
	r[-1].width = width;
	r[-1].origin.h = -minX;
	r[-1].origin.v = maxY;
#ifdef MC68000
	if (options & FontSun100)
	    r[-1].stride = bBox.v;
	else
#endif
	    r[-1].stride = byteWidth;
	font->c[c] = r;
	ReadGenericCharacter(fp, r, &start, options);
	if (c < FontPrefixOf(font)->minChar) FontPrefixOf(font)->minChar = c;
	if (c > FontPrefixOf(font)->maxChar) FontPrefixOf(font)->maxChar = c;
	fseek(fp, savePos+4, 0);
      }

    return OK;
  }
static SkipToBoc(fp) /* skip to a Beginning of Character command */
    register FILE *fp;
  { int c;
    while (c = GetUnsigned1(fp))
        switch (c)
	  {
	  case xxx1:
	    fseek(fp, GetUnsigned1(fp), 1); continue;
	  case xxx2:
	    fseek(fp, GetUnsigned2(fp), 1); continue;
	  case yyy:
	    GetSigned4(fp); continue;
	  case no_op:
	    continue;
#if NEW_GF
	  case boc1:
	    return boc1;
#endif
	  case boc:
	    return boc;
	  default:
	    return 0;
	  }
  }

static ReadGenericCharacter(fp, r, start, options)
    register FILE *fp;
    register VRaster *r;
    Vector *start;
   {
    int i, color = 0, x, y;
    struct BitPtr bPtr;
    x = start->h; y = start->v;
    while ((i = GetUnsigned1(fp)) != eoc)
      { register int n; /* parameter for commands */
	if (i >= paint_1 && i <= paint_63)
	  {n = i - (paint_1 - 1); goto paint;}
	if (i >= new_row_0 && i <= new_row_0 + max_new_row)
	  { n = i - new_row_0; goto new_row;}
	switch (i)
	  {
	    case paint_0:  n = 0; goto paint;
	    case paint1: n = GetUnsigned1(fp); goto paint;
	    case paint2: n = GetUnsigned2(fp); goto paint;
	    case skip0: n = 0; goto skip;
	    case skip1: n = GetUnsigned1(fp); goto skip;
	    case skip2: n = GetUnsigned2(fp); goto skip;
/* ??? sign of y? */
/*	    case newrow: n = GetSigned4(fp); goto new_row;*/
	    case no_op: continue;
	    case xxx1: n = GetUnsigned1(fp); goto xxx;
	    case xxx2: n = GetUnsigned2(fp); goto xxx;
	    case yyy: n = GetSigned4(fp); continue;
	    default:
		printf("unknown mf op: %d at %d\n", i, ftell(fp));
		abort("ReadGenericFont: bad font file"); continue;
    	  }
      xxx: fseek(fp, n, 1); continue;
      new_row:
	y++; x = start->h + n;
	color = 1; continue;
      skip: n++; y += n; x = start->h; color = 0;
	continue;
      paint:
	if (color > 0) 
	  {
#ifdef MC68000
	    if (options & FontSun100)
	      {
		SetBitPtr_Sun1(&bPtr, r, x, y);
		PaintNBitsSun100(&bPtr, n);
	      }
	    else
#endif
	      {
		SetBitPtr(&bPtr, r, x, y);
		PaintNBits(&bPtr, n);
	      }
	  }
	x += n;
	color = 1 - color;
      }
    return;
  }
