/* Generic procedure body for unary rasterop functions:
 * RasteClear, RasterSet and RasterInvert
 *
 * Defined in terms of certain macros which must be in the C sources:
 * MASKOP(dst, mask)
 * WORDOP(dst)
 * CLEAR
 * RASTER - The VRaster to work on
 */

/* For left and right edges we need a mask.
 * Normally, this has ones where the RASTER is to change.
 * But if CLEAR is set, use the opposite convention.
 */
#ifndef CLEAR
#define MERGEMASKS(mdst, msrc) ((mdst) &= (msrc))
#define LEFTMASK(n) LeftZeros(n)
#define RIGHTMASK(n) ~LeftZeros(n)
#else
#define MERGEMASKS(mdst, msrc) ((mdst) |= (msrc))
#define LEFTMASK(n) ~LeftZeros(n)
#define RIGHTMASK(n) LeftZeros(n)
#endif

  { register BitWord *p;
    BitWord leftMask, rightMask;
    BitWord *rowStart = (BitWord*)RASTER[-1].start;
    int i, cols;
    register j = BitOffset(RASTER);
    leftMask = LEFTMASK(j);
    j += RASTER[-1].bBox.h;
 /* check if only one column */
    if (j <= BitWordLen)
      {
	/* Note!  j may be equal to BitWordLen, in which case we DO want
	 * rightMask to be an empty mask
	 */
	rightMask = RIGHTMASK(j);
	MERGEMASKS(leftMask, rightMask);
	p = rowStart;
	for (i = RASTER[-1].bBox.v; --i >= 0; ) /* for each row */
	  {
	    MASKOP(*p,leftMask);
	    p = (BitWord*)((BitUnit*)p + RASTER[-1].stride);
	  }
	return;
      }
    rightMask = RIGHTMASK(j & (BitWordLen - 1));
    j -= BitWordLen;
    cols = j >> BitWordLog;
    for (i = RASTER[-1].bBox.v; --i >= 0; ) /* for each row */
      {
	p = rowStart;
	MASKOP(*p++,leftMask); /* do left column */
	for (j = cols; --j >= 0; ) WORDOP(*p++); /* do intermediate columns */
	MASKOP(*p, rightMask); /* do right column */
	rowStart = (BitWord*)((BitUnit*)rowStart + RASTER[-1].stride);
      }
  }
