#include "bitptr.h"
struct BitPtr BitPtr;

/* SearchBit(bitPtr, color)
 * Increment bitPtr until a pixel of the right color is found.
 * return:
 *	1 if found
 *	0 if end-of-line and color has SearchEdge mode.
 *	-1 if end-of-raster.
 */
SearchBit(bitPtr, color)
    register struct BitPtr *bitPtr;
    u_short color;
  { u_short word;
    int bit;
    register u_short *ptr;
    register CharPrefix *r = bitPtr->r;
#if 0
    int cStride = r->stride;
#define BitOffset(r) (r)->bitOffset
#define BWidth(r) (r)->width
#else
#define cStride 1
#define BWidth(r) (r)[-1].bBox.h
#endif
    int totalWidth = BitOffset(r) + BWidth(r);
    u_short rightMask = 0xFFFF << ((16 - totalWidth) & 15);
    int col, lastCol = (totalWidth - 1) >> 4;
    u_short skipValue = (color&SearchBlack) ? 0 : (u_short)(-1);

    col = (BitOffset(r) + bitPtr->x) >> 4;
    for (; ; col = 0)
      { /* scan along one row */
	ptr = bitPtr->ptr;

	if (col >= lastCol)
	  {
	    if (word = ((*ptr ^ skipValue) & rightMask & bitPtr->mask))
		goto found;
	  }
	else
	  {
	    if (word = ((*ptr ^ skipValue) & bitPtr->mask))
		goto found;
	    for (; ptr += cStride, ++col < lastCol;)
		if ((word = *ptr ^ skipValue) != 0)
		    goto found;
	    if (word = ((*ptr ^ skipValue) & rightMask))
		goto found;
	  }

	if ((color & (SearchUp|SearchDown)) == 0) goto notfound;
	if (color & SearchUp)
	  { if (--bitPtr->y < 0) return -1; }
	else /* if (color & SearchDown) */
	  { if (++bitPtr->y >= r[-1].bBox.v) return -1; }
	SetBitPtr(bitPtr, r, 0, bitPtr->y);
#if 0
	bitPtr->x = 0;
	bitPtr->mask = 0xFFFF >> BitOffset(r);
#endif
      }

  notfound:
    bit = ((totalWidth - 1) & 15) + 1;
    skipValue = 0;
    goto exit;
  found:
    /* word == *ptr */
    for (bit = 0; (word & 0x8000) == 0; bit++) { word <<= 1; }
    skipValue = 1;
  exit:
    bitPtr->x = bit + 16*col - BitOffset(r);
    bitPtr->ptr = ptr;
    bitPtr->mask = 0xFFFF >> bit;
    return skipValue;
  }

BoundingBox(r, dx, dy, h, w)
    register CharPrefix *r;
    int *dx, *dy, *h, *w;
  { struct BitPtr bitPtr;
    u_short lword, rword;
    register u_short *ptr;
    int totalWidth = BitOffset(r) + r[-1].bBox.h;
    int firstCol, lastCol = (totalWidth - 1) >> 4;
    short lcol, rcol, colSkip;
    register i;
    BitWord *leftPtr, lmask;
    register BitWord mask;

    if (r[-1].bBox.h <= 0 || r[-1].bBox.v <= 0) return 0;

    /* look for top edge */
    SetBitPtr(&bitPtr, r, 0, 0);
    if (SearchBit(&bitPtr, SearchBlack|SearchDown) < 0) return 0;
    *dy = bitPtr.y;
    leftPtr = (u_short*)((u_char*)r[-1].start + *dy * r[-1].stride);

    /* look for bottom edge */
    SetBitPtr(&bitPtr, r, 0, r[-1].bBox.v-1);
    SearchBit(&bitPtr, SearchBlack|SearchUp);
    *h = bitPtr.y - *dy + 1;
/*    colSkip = r->stride - *h; */
    colSkip = BitAlign - *h * r[-1].stride;

    /* get left edge */
    mask = 0xFFFF >> BitOffset(r);
    lmask = mask;
    ptr = leftPtr;
    for (lword = 0, firstCol = 0; firstCol < lastCol; firstCol++)
      {
	for (i = *h; --i >= 0; )
	  { lword |= *ptr; ptr = (BitWord*)((BitUnit*)ptr + r[-1].stride); }
	lword &= mask; mask = (u_short)(-1);
	ptr = (BitWord*)((BitUnit*)ptr + colSkip);
	if (lword != 0) break;
      }
      
    /* get right edge */
    mask = 0xFFFF << ((16 - totalWidth) & 15);
    ptr = leftPtr + lastCol;
    rword = 0;
    colSkip -= 2 * BitAlign;
    for (;; lastCol--)
      {
	for (i = *h; --i >= 0; )
	  { rword |= *ptr; ptr = (u_short*)((u_char*)ptr + r[-1].stride); }
	rword &= mask;
	if (rword != 0) break;
	mask = (u_short)(-1);
	ptr = (BitWord*)((BitUnit*)ptr + colSkip);
      }
      
    if (lword == 0) lword = rword & lmask;
    for (i = 0; (lword & 0x8000) == 0; i++) { lword <<= 1; }
    *dx = firstCol * 16 + i - BitOffset(r);
    for (i = 16; (rword & 1) == 0; i--) { rword >>= 1; }
    *w = lastCol * 16 + i - BitOffset(r) - *dx;
    
    return 1;
  }
