#include <Vfont.h>
extern VRaster *AllocRaster();

VRaster *
NewRaster(rows, cols)
 /* NewRaster:
  * Allocate a raster with the specifyed size bitmap, as the head
  * a circular linked list.
  */
  { register VRaster *r = AllocRaster(sizeof(VRaster*));
    if (r != (VRaster*)AllocFailure)
      {
	NextRaster(r) = r;
	Options(r[-1]) = RasterLinked|RasterListHead;
	r[-1].bBox.v = rows; r[-1].width.v = rows << 16;
	r[-1].bBox.h = rows; r[-1].width.h = cols << 16;
	r[-1].origin.h = 0; r[-1].origin.v = 0;
	r[-1].xoffset = 0;
	r[-1].stride = ((cols + (BitWordLen - 1)) >> BitWordLog) << BitAlignLog;
	if ((r[-1].start = (BitUnit*)calloc(rows, r[-1].stride)) == (BitUnit*)0)
	  {
	    free(r);
	    return (VRaster*)AllocFailure;
	  }
      }
    return r;
  }
