/*
 * ptr = LoadFileRegion(name, &length, &error)
 * Copy (or map) the file named 'name' into a buffer, and return the address
 * of the buffer.
 *
 * ReleaseFileRegion(ptr)
 * Release the buffer and other resources allocated by a LoadFileRegion.
 */

#include <stdio.h>
extern char *malloc();

char *
LoadFileRegion(name, length, error)
    char *name;
    int *length;
    SystemCode *error;
  { FILE *f = Open(name, FREAD, error); int len; char *p;
    if (*error != OK) return NULL;
    fseek(f, 0, 2);
    len = ftell(f);
    if (length != NULL) *length = len;
    fseek(f, 0, 0);
    p = malloc(len);
    if (p == NULL) *error = NO_MEMORY;
    else fread(p, len, 1, f);
    fclose(f);
    return p;
  }

ReleaseFileRegion(ptr)
    char *ptr;   /* must have been previously returned by LoadFileRegion */
  {
    free(ptr);
  }
