/* defines the array BitReverse:
 * BitReverse[i] is the bitreversal of (unsigned char) i.
 */
#define List2(x)	x, 128+x,
#define List4(x)	List2(x)   List2(64+x)
#define List8(x)	List4(x)   List4(32+x)
#define List16(x)	List8(x)   List8(16+x)
#define List32(x)	List16(x)  List16(8+x)
#define List64(x)	List32(x)  List32(4+x)
#define List128(x)	List64(x)  List64(2+x)
#define List256(x)	List128(x) List128(1+x)
unsigned char BitReverse[256] = {
  List256(0)
};
