#ifdef Q
#include "stdio.h"
#include "graphics.h"
#endif Q
#include "Vfont.h"
#include "Venviron.h"

VRaster *
AllocRaster(size)
    int size;	/* - of raster to allocate in BitUnits */
  {
    register VRaster *r;
#ifdef Q
    register i;
    register BitWord *ptr;
    r = (VRaster*)Alloc(&Raster, size);
    if (False(r)) return AllocFailure;
    r[-1].xoffset = 0;
    ptr = (BitWord*)r;
    for (i = (size + 1) >> BitAlignLog; --i >= 0; ) *ptr++ = 0;
#else
    if ((r = (VRaster*)calloc(1, sizeof(CharPrefix) + size)) == NULL)
	return AllocFailure;
    r++;
#endif Q
    r[-1].start = (BitUnit*)r;
    return r;
  }

Vfont *
AllocFont()
  { Vfont *font;
#ifdef Q
    font = (Vfont*)Alloc(&Font, 256*sizeof(short**));
    if (False(font)) return AllocFailure;
#else
    font = (Vfont*)malloc(sizeof(struct FontPrefix)+256*sizeof(short**));
    if (font == NULL) return AllocFailure;
    font = (Vfont*)((struct FontPrefix*)(font) + 1);
#endif
    FontPrefixOf(font)->TFMwidth = NULL;
    return font;
  }
