/* Convert between rasters in sun100 format (column-order) and
 * standard order (row order).
 */

RowToColRaster(colRaster, rowRaster, height, cols, rowWidth)
    register short *colRaster, *rowRaster;
    register int rowWidth; /* width in bytes of each row in the rowRaster */
    register height;
    int cols; /* no. of 16-bit columns to write in 'colRaster' */
  { register x, y;
    for (x = cols; --x >= 0; )
      { register short *wPtr;
        wPtr = rowRaster++;
	for (y = height; --y >= 0; )
	    {*colRaster++ = *wPtr; wPtr = (short *)((char *)wPtr + rowWidth);}
      }
  }

ColToRowRaster(rowRaster, colRaster, height, cols, rowWidth)
    register short *colRaster, *rowRaster;
    register int rowWidth; /* width in bytes of each row in the rowRaster */
    register height;
    int cols; /* no. of 16-bit columns to write in 'colRaster' */
  { register x, y;
    for (x = cols; --x >= 0; )
      { register short *wPtr;
        wPtr = rowRaster++;
	for (y = height; --y >= 0; )
	    {*wPtr = *colRaster++; wPtr = (short *)((char *)wPtr + rowWidth);}
      }
  }
