/* QueryExec: ask the Exec Server about the status of an executive */

#include <Vio.h>
#include <Vexec.h>

SystemCode QueryExec(execserver, execid, execpid, program, status)
  ProcessId execserver;
  int execid;
  ProcessId *execpid;	/* pid of the exec */
  ProcessId *program;	/* pid of program running under the exec */
  short *status;	/* free, loading, or running */
  {
    Message msg;
    register ExecRequest *req = (ExecRequest *) msg;
    register ExecReply *reply = (ExecReply *) msg;
    register SystemCode r;

    req->requestcode = QUERY_EXEC;
    req->execid = execid;
    Send(req, execserver);
    r = reply->replycode;
    if (r != OK) return(r);

    *execpid = reply->pid;
    *program = reply->program;
    *status = reply->status;
    return(req->requestcode);  /* actually the replycode */
  }
