/* CreateExec: routine by which a client requests to have an exec created,
 * and specifies its standard i/o and context.  It returns the execid of
 * the exec created, a small integer which will specify this exec in any
 * subsequent requests.
 */

#include <Vio.h>
#include <Vteams.h>
#include <Vexec.h>

int CreateExec(execserver, inserver, infile, outserver, outfile,
		errserver, errfile, nameserver, context, flags, execpid, error)
  ProcessId execserver;
  ProcessId inserver, outserver, errserver; /* the i/o servers */
  InstanceId infile, outfile, errfile;
  ProcessId nameserver;
  ContextId context;
  short flags;		/* whether exec is to own stdin, stdout, stderr */
  ProcessId *execpid;   /* returns the process id of the new exec */
  SystemCode *error;	/* returns the error code, if failure */
  {
    Message msg;
    register ExecRequest *req = (ExecRequest *) msg;
    register ExecReply *reply = (ExecReply *) msg;
    register SystemCode r;

    req->requestcode = CREATE_EXEC;
    req->stdinserver = inserver;
    req->stdinfile = infile;
    req->stdoutserver = outserver;
    req->stdoutfile = outfile;
    req->stderrserver = errserver;
    req->stderrfile = errfile;
    req->nameserver = nameserver;
    req->context = context;
    req->flags = flags;		/* nonzero -> hold until a START_EXEC */

    Send(req, execserver);
    r = reply->replycode;
    if (r != OK) goto End;

    if (flags & RELEASE_INPUT)
	SetInstanceOwner(inserver, infile, reply->pid);
    if (flags & RELEASE_OUTPUT)
	SetInstanceOwner(outserver, outfile, reply->pid);
    if (flags & RELEASE_ERR)
	SetInstanceOwner(errserver, errfile, reply->pid);
    if (execpid) *execpid = reply->pid;

    if (flags)
      {
	req->requestcode = START_EXEC;
	Send(req, execserver);
	r = reply->replycode;
      }
End:
    if (error) *error = r;
    return(reply->execid);
  }
