/* Internal support routines only - subject to change without notice! */

#include <Vio.h>
#include <Vquerykernel.h>

#define FALSE 0
#define TRUE 1

/* The following constants should correspond to those in the
 * various b.out.h files.
 */
#ifndef LITTLE_ENDIAN
#define	FMAGIC	0x00000107	/* == 0407 */
#define	OMAGIC	0x07010000	/* == ByteSwapLong(0407) */
#define	NMAGIC	0x08010000	/* == ByteSwapLong(0410) */
#define	ZMAGIC	0x0B010000	/* == ByteSwapLong(0413) */
#else LITTLE_ENDIAN
#define	FMAGIC	0x07010000	/* == ByteSwapLong(0407) */
#define	OMAGIC	0x00000107	/* == 0407 */
#define	NMAGIC	0x00000108	/* == 0410 */
#define	ZMAGIC	0x0000010B	/* == 0413 */
#endif

/* The following routine is used to check the magic numbers of program 
 * files.  It turns out that it is needed only to check program
 * files whose names don't have version-identifying suffixes.
 * (For suffixed file names, we can just assume that the suffix is telling the
 * truth, and leave it to the team server to check the file.)
 * Thus, if we were to disallow unsuffixed program file names, then we would 
 * eliminate the need for the exec to read magic numbers, avoid n^2
 * complexity as more processor families are supported, and simplify the exec 
 * routines in other ways.  (Hint, hint)
 */
int ValidMagicNum(magicNum, procFamily)
    unsigned long magicNum;
    unsigned char procFamily;
  {
    switch (procFamily)
      {
	case PROC_FAM_68000:
	    return (magicNum == FMAGIC);
	case PROC_FAM_VAX11:
	    return ((magicNum == ZMAGIC) ||
	    	    (magicNum == NMAGIC) ||
		    (magicNum == OMAGIC));
	default:
	    return (FALSE);
      }
  }
