/* Internal support routines only - subject to change without notice! */

#include <Vio.h>
#include <Vteams.h>
#include <Vquerykernel.h>

#define LineLength 128		/* Max size of a char. string buffers */

extern char DefaultProgram[];
extern File *OpenProgFile();
extern ProcessId LoadTeamFromFile();

ProcessId SpecLoadProgram(argv, teamServerPid, rtMsg, path, concurrent, error)
    char *argv[];	/* Program arguments (including name). */
    ProcessId teamServerPid; /* host to execute on */
    RootMessage *rtMsg;
			/* Root message to use.  NULL => default settings. */
    char *path;		/* Search path to use for finding the program
			   file.  NULL indicates that the default should
			   be used. */
    int concurrent;	/* Specifies whether the program should be 
			   owned by the system (concurrent = 1) or 
			   by the user (concurrent = 0). */
    SystemCode *error;	/* Return code. */
    /* Sets up the new team at a specific host - "teamServerPid". */
  {
    ProcessId newpid;
    unsigned char procFamily;
    File *progFile = NULL;
    char nameBuf[LineLength];

    /* Determine the machine type of the execution host. */
      {
	Message msg;
	MachineConfigurationReply *reply = (MachineConfigurationReply *)msg;

	QueryKernel(teamServerPid, MACHINE_CONFIG, reply);
	if (reply->replycode != OK)
	  {
	    if (!ValidPid(teamServerPid))
		*error = NONEXISTENT_PROCESS;
	    else
		*error = INTERNAL_ERROR;
	    return(0);
	  }
	procFamily = (reply->processor)&PROC_FAMILY;
	if ((procFamily < 0) ||
	    ((procFamily>>PROC_FAMILY_SHIFT) >= NUM_PROC_FAMILIES))
	  {
	    *error = INTERNAL_ERROR;
	    return(0);
	  }
      }

    /* Check the search path, to try to find an appropriate program file: */
    if (!SearchPathMatch(argv, path, nameBuf, 1 /* => specific host. */,
			 procFamily, &progFile,
			 NULL, /* This parameter is irrelevent for us. */
			 error))
	return (0);

    /* Having found a program file, attempt to load it as a new team. */
    newpid = LoadTeamFromFile(teamServerPid, progFile, nameBuf, concurrent,
    			      argv, rtMsg, rtMsg, error);

    /* At this point the new team is ready to run  */
    return(newpid);
  }
