/*
 * error.c - A table of error message strings
 *
 * Bill Nowicki January 1983
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vtermagent.h>
#include <Vsession.h>

struct codeEntry
  {
    SystemCode code;
    char *string;
  }
    CodeTable[] =
  {
	0xC001,	"Illegal request",
	0xC002,	"No reply",
	0xC003, "Retry",
	0xC004, "Bad args",
	0xC005, "Bad address",
	0xC006, "Bad buffer",
	0xC007, "No server resources",
	0xC008, "No memory",
	0xC009, "No permission",
	0xC00A, "Power failure",
	0xC00B, "Not found",
	0xC00C, "Busy",
	0xC00D, "Timeout",
	0xC00E, "Bad state",
	0xC00F, "Aborted",
	0xC010, "Nonexistent process",
	0xC011, "Not awaiting reply",
	0xC012, "Bad process priority",
	0xC013, "No free process descriptors",
	0xC014, "Invalid file id",
	0xC015, "Not readable",
	0xC016, "Not writeable",
	0xC017, "End of file",
	0xC018, "Invalid mode",
	0xC019, "Mode not supported",
	0xC01A, "Bad byte count",
	0xC01B, "Bad block number",
	0xC01C, "Io break",
	0xC01D, "Internal error",
	0xC01E, "Device error",
	0xC01F, "Request not supported",
	0xC020, "Nonexistent session",
	0xC021, "Duplicate name",
	0xC022, "Server not responding",
	0xC023, "Invalid context id",
	0xC024, "Not a context",
	0xC025, "Kernel timeout",
	0xC026, "Illegal name",
	0xC027, "Has substructure",
	0xC028, "Bad forward",
	0xC029, "Awakened",
	0xC02A, "No free team descriptors",
	0xC02B, "No free group descriptors",
	0xC02C, "Bad reply segment",
	0xC02D, "Discard reply",
	0xC02E, "Not here",
	0xC02F, "Retry as a unicast",
	0xC030, "Multi-manager object",
	0xC031, "OK, and more replies may arrive",

/* System Standard Request Codes: to be used requesting all standard
 * system services.
 *
 */
	0x6000, "No operation",
	0x5801, "Create instance",
	0x4801, "Create instance retry",
	0x6002, "Query instance",
	0x6003, "Release instance",
	0x7404, "Read instance",
	0x7805, "Write instance",
	0x6005, "Write short instance",
	0x6006, "Set break process",
	0x6007, "Set instance owner",
	0x6008, "Query file",
	0x6009, "Modify file",
	0x600A, "Set prompt",
	0x5C0B, "Exception request",
	0x600C, "Register handler",
 	0x780E, "Named query file",
	0x780F, "Named modify file",
	0x6010, "Get time",
	0x6012, "Terminate team",
	0x7813, "Lookup server",
	0x7414, "Read and forward",
	0x5815, "Remove file",
	0x6C17, "Get absolute name",
	0x7818, "Get context id",
	0x7419, "Get context name",
	0x741A, "Get file name",
	0x741B, "Read descriptor",
	0x7C1C, "Named read descriptor",
	0x781D, "Write descriptor",
	0x781E, "Named write descriptor",
	0x581F, "Create file",

	0x4020, "Create process",
	0x6021, "Destroy process",
	0x7422, "Query process",
	0x7823, "Modify process",
	0x4024, "Create team",
	0x6025, "Set team priority",
	0x6026, "Set team size",
	0x4027, "Delay",
	0x6028, "Wakeup",
	0x6029, "Get time",
	0x602a, "Set time",
	0x602b, "Set pid",
	0x402C, "Query kernel",
	0x602D, "Create group",
	0x602E, "Query group",
	0x602F, "Join group",
	0x6030, "Leave group",
	0x4031, "Create host",
	0x6032, "Set user number",
	0x6033, "Get user number",
	0x4034, "Force exception",
	0x6035, "Set debug mode",

/* Authentication server requests */
	0x4C36, "Authenticate",
	0x5C37, "Add user",
	0x4C38, "Delete user",
	0x4C39, "Modify user",
	0x4C3A, "Map user name",
	0x4C3B, "Map user number",
	
/* More kernel requests */
	0x603F, "Query processor usage",
	0x6040, "Get pid",
	0x6041, "Reboot",
	0x7442, "Read kernel memory",
	0x7443, "Profile",
	0x6044, "Query process priority",
	0x6045, "Set process priority",
	0x6046, "Get forwarder",
	0x7047, "Clear modified pages",
	0x7448, "Return modified pages",

	0x6049, "Get object owner",
	0x604A, "Set object owner",
	0x404B, "Freeze host",
	0x404C, "Unfreeze host",
	0x404D, "Force send",
	0x404E, "Destroy host",
	0x744F, "Extract host",

	0x5850, "Rename file",
	0x7451, "Query storage stats",
	0x6052, "Modify storage stats",
	0x7C53, "Put on green hat",
	0x6054, "Get status request",
	0x6855, "Query name",
	0x6056, "Delete user correspondence",
	0x6857, "Add user correspondence",
	0x4058, "Create duplex instance",

	0x7859, "Transfer host",
	0x405A, "Copy from",
	0x405B, "Copy to",
	
/* Special "terminal agent" request codes, from Vtermagent.h: */
	0x3800, "Set Banner Request",
	0x2001, "Switch Input",
	0x2002, "Event Request",
	0x2003, "Redraw Request",
	0x3804, "Line Edit Request",
	0x2004, "Get Raw IO",
	0x2005, "Modify Pad Request",
	0x2006, "Query Pad Request",
	0x2007, "Die",

/* A special request code, from Vsession.h: */
	0x4486, "Get Instance Info",

	0, "OK",
	0, 0
 };

static char *ShortString(number)
    register number;
  {
  	/*
	 * small and simple hex printer to avoid including printf
	 * in everything.
	 */
    static char buf[7];
    register char *table = "0123456789abcdef";

    buf[0] = '0';
    buf[1] = 'x';
    buf[2] = table[ (number>>12) & 15 ];
    buf[3] = table[ (number>>8 ) & 15 ];
    buf[4] = table[ (number>>4 ) & 15 ];
    buf[5] = table[ (number    ) & 15 ];
    buf[6] = 0;
    return(buf);
  }


char *ErrorString(err)
  SystemCode err;
  {
    static char buf[256];
    register struct codeEntry *p = CodeTable;

    /* Check if we recognize this system code. */
    for (;p->string;p++)
      if (p->code==err)
	return(p->string);
	
    /* Not recognized: print out the information we can infer. */
    strcpy(buf,"Strange code(");
    strcat(buf,ShortString(err));
    strcat(buf,")=");
    if( err&SYSTEM_CODE )
      {
	strcat(buf,"System");
      }

    if( err&REPLY_BIT )
      {
	strcat(buf,"Reply+");
	if ( err&ANONYMOUS_REPLY_BIT ) strcat(buf,"Anonymous+");
	if ( err&REPLY_SEGMENT_BIT ) strcat(buf,"ReplySegment+");
	if ( err&IMMEDIATE_REPLY_BIT ) strcat(buf, "Immediate+");
	err &= ~(SYS_REPLY_CODE|ANONYMOUS_REPLY_BIT|REPLY_SEGMENT_BIT|
			IMMEDIATE_REPLY_BIT);
			
      }
    else
      {
	strcat(buf,"Request+");
        if( err&SEGMENT_PRESENT )
          { 
	    strcat(buf,"Segment+");
            if ( err&READ_BIT ) strcat(buf,"Read+");
            if ( err&WRITE_BIT ) strcat(buf,"Write+");
	  }
	if ( err&DATAGRAM_SEND_BIT ) strcat(buf, "Datagram+");
        err &= ~(SYSTEM_CODE|SEGMENT_PRESENT|DATAGRAM_SEND_BIT);
      }

     strcat(buf,ShortString(err));
     return(buf);
  }

