/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 *
 * Ethernet header: manifests, types, structs local to Ethernet code.
 */

#ifndef _ETHERNET
#define _ETHERNET

#include "Vethernet.h"

#define	ushort	unsigned short
#define	uchar	unsigned char
#define	uint	unsigned int

/*    Definitions for the Deqna ethernet interface    */

#define	Deqna		((deqna_reg_t *)(0x20000000 + 014440))
#define EnetAddrLen	6

/* parameters */
#define TXLISTLEN		1	/* number of transmit buffers */
#define RXLISTLEN		20	/* number of receive buffers */
#define	QNAWAITTIME		10000	/* a loop of at least 100 microsecs */
#define	ENET_READER_TIMEOUT	5	/* discard a packet after 50 ms */

/* Set Up modes */
#define	QNA_AllMultiCast	0x1
#define	QNA_Promiscuous		0x2
#define	QNA_No_LED		0x0
#define	QNA_LED1_out		0x4
#define	QNA_LED2_out		0x8
#define	QNA_LED3_out		0xc
#define	QNA_SanityValue(lognumsecs)	(lognumsecs*0x10)

/* Descriptor Status */
#define QNA_LastNoErr	0
#define QNA_LastErr	1
#define QNA_Unused	2
#define QNA_Using	3

/* Descriptor status expressed as a complete int */
#define QNA_BDLLastNoErr	(0<<14)
#define QNA_BDLLastErr		(1<<14)
#define QNA_BDLUnused		(2<<14)
#define QNA_BDLUsing		(3<<14)

/* Defines to mask out bits in the Control and Status Register */
#define	QNARCVENABLE	0x0001		/* Receiver Enable */
#define	QNARESET	0x0002		/* Reset */
#define	QNANXMINT	0x0004		/* Nonexistent memory interrupt */
#define	QNABOOTROM	0x0008		/* Boot diagnostic ROM */
#define	QNATXBDLBAD	0x0010		/* Transmit List invalid */
#define	QNARXBDLBAD	0x0020		/* Receive List invalid */
#define	QNAINTENABLE	0x0040		/* Interrupt enable */
#define	QNAXMTINT	0x0080		/* Transmit Interrupt Request */
#define	QNAILOOP	0x0100		/* NOT Internal Loopback */
#define	QNAELOOP	0x0200		/* External Loopback */
#define	QNATIMERENABLE	0x0400		/* Sanity Timer interrupt enable */
#define	QNAFUSEOK	0x1000		/* Power is being supplied */
#define	QNACARRIER	0x2000		/* carrier sense signal */
#define	QNARCVINT	0x8000		/* Recieve Interrupt Request */

typedef union
  {
    ushort enet_addr[EnetAddrLen];
    struct
      {
	ushort	unused[2];
	ushort	rxBDLlo;
	ushort	rxBDLhi;
	ushort	txBDLlo;
	ushort	txBDLhi;
	ushort	vector;
	ushort	csr;
      } regs;
} deqna_reg_t;


typedef	union
  {
    int	allofit;
    struct
      {
        uint	:4,
		count:4,	/* collision count */
		fail:1,		/* no collision pulse */
		abort:1,	/* transmission aborted */
		ste16:1,	/* default sanity timer on */
		nocar:1,	/* no carrier */
		loss:1,		/* carrier loss during xmit */
		:1,
		use:2,		/* use status */
		tdr:14,		/* time domain reflectometer value */
		:2;
      } tx;
    struct
      {
	uint	ovf:1,		/* overflow */
		crcerr:1,	/* crc error */
		frame:1,	/* framing error */
		tooshort:1,	/* short packet */
		:4,
		rblhi:3,	/* bits 8-10 of rx msg length */
		runt:1,		/* runt message */
		discard:1,	/* packet discarded */
		esetup:1,	/* eloop/setup packet */
		use:2,		/* use status */
		rbllo:8,	/* low byte of rx msg length */
		:8;
      } rx;
} status_t;

/*
*	the type of a Buffer Descriptor.
*	These tell the DEQNA where to put packets.
*/
typedef struct
  {
    uint	:14,
		flag:2,		/* the flag */
		addrhi:6,	/* High order address bits */
		HBOStart:1,	/* High Byte Only Start */
		LBOEnd:1,	/* Low Byte Only End */
		:4,
		setUp:1,	/* Is a setup packet */
		endOfMsg:1,	/* buffer is the last of the message */
		chain:1,	/* address is a chain address */
		valid:1;	/* is a valid buffer */
    ushort	addrlo;		/* low order address bits */
    ushort	size;		/* the size of this buffer */
    status_t	status;		/* the two status words */
} QNABD_t;


/*
*	the deqna data structure
*/
typedef struct {
	QNABD_t		txlist[TXLISTLEN+1];
	QNABD_t		rxlist[RXLISTLEN+1];
	EnetBlock	txbuff;
	EnetBlock	rxbuff[RXLISTLEN];
	uchar		setupbuff[16][8];
} Qna_t;

#undef ushort
#undef uchar
#undef uint

#endif _ETHERNET
