/*
 * Return the full name for the user associated with the
 *  given process as a malloc'ed string.  It can be
 *  freed by the caller.
 */

#include <Venviron.h>
#include <Vauthenticate.h>

extern char *strsave();

char *FullUserName(pid)
  {
    AuthRec ar;
    char *name;

    if ( MapUID(User(pid), &ar) != OK ) return NULL;
    name = strsave(ar.fullname);
    DestroyAuthRec(&ar);
    return name;
  }
