/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * VAX-11/microvax dependent timer functions.
 *
 * MicroVAX Timer interrupts at 100 Hz (every 10 milliseconds).
 *
 */

#include "Vexceptions.h"
#include "interrupt.h"
#include "asmdefs.h"
#include "process.h"


Init_timer()
  {
  /*
   * Perform the required initialization for the timer.
   * The VAX has two timers (or clocks).  The TODR is the time
   * of year (day) register, it counts
   * in tens of ms.  The Interval timer is the interrupt generator
   * (on the 730) which can be set to an arbitrary number of ms.
   * For convenience this number is set to 10 ms.
   * There are three Processor registers associted with the interval timer
   * Interval Clock Control, Next Interval Count, Interval Count.
   * When the interval count overflows, it is  automatically loaded with 
   * the value in the NIC registers.
   */
    extern int Asm_MsTimerInterrupt();

    setexvec(Asm_MsTimerInterrupt, VecIntervalTimer);
#ifndef MICROVAX
    /* initialize the todr to be nonzero so it counts */
    asm("    mtpr    $1, $todr");
    asm("    mtpr    $-10000, $nicr");
#endif
    asm("    mtpr    $0x8000d1, $iccs");	/* enable timer interrupts */
  }


/* Interrupt service routine that calls machine-independent routine
 * on each interrupt. Assumes no need to disable interrupts because
 * no higher priority interrupt unblocks processes.
 */
Call_inthandler(MsTimerInterrupt);/* Macro expansion to interrupt-invoked
				   * C call to MsTimerInterrupt
				   */
MsTimerInterrupt()
  {
#ifndef MICROVAX
    /* acknowledge by clearing the ERR and INT bits, setting RUN and IE. */
    asm("    mtpr    $0x800000c1, $iccs");
#endif
    Timer_interrupt();
  }


unsigned long GenerateRandomNumber()
  {
#ifdef MICROVAX
    /*
     * no todr register, so use a random generated from the
     * ethernet address as a seed (initialized in deqna.c)
     */
    extern long random();
    return(random());
#else
    /* C puts the return value in r0 */
    asm("    mfpr    $todr, r0");
#endif
  }
