/*
 * V Kernel - Copyright (c) 1985 by Stanford University
 *
 * Kernel Qvss Mouse support routines
 *
 * Note that the Mouse device supposedly is able to interrupt on mouse
 * move, but it doesn't seem to like to do that.  Also, it can interrupt
 * on mouse down, but not mouse up events.  We just poll it every Vsync
 * interrupt (~60Hz?) and eliminate all the problems.
 */

#include "Venviron.h"
#include "interrupt.h"
#include "qvss.h"


/* Imports */
extern	CheckMouseReader();
extern short	MouseX, MouseY, MouseEvent;
extern unsigned short	MouseButtons;

/* Exports */
extern	StartMouse();
extern	StopMouse();
extern	IntQvssMousePoll();

/* Private */
static unsigned short	oldMouseX = 0, oldMouseY = 0;

/* Forward */


Call_inthandler(IntQvssMousePoll);

StartMouse() {;}

StopMouse() {;}

IntQvssMousePoll()
  {
    unsigned short mouseButtons;
    short mousePos;
    register unsigned short newX;
    register unsigned short newY;
    register unsigned short delta;

    /* lower our IPL to something reasonable */
    asm("	mtpr	$0x14, $ipl");
    
    mouseButtons = 7&(Qvss->regs[QV_CSR]>>8);
    mousePos = Qvss->regs[QV_MOUSE];
    newX = mousePos&0x0ff;
    newY = (mousePos>>8)&0x0ff;
    if (mouseButtons != MouseButtons || newX != oldMouseX || newY != oldMouseY)
      {
	if (oldMouseX > newX)
	    MouseX -= (0x80 <= (delta = oldMouseX-newX)) ? 0x100-delta : delta;
	else
	    MouseX += (0x80 <= (delta = newX-oldMouseX)) ? 0x100-delta : delta;
	if (oldMouseY > newY)
	    MouseY += (0x80 <= (delta = oldMouseY-newY)) ? 0x100-delta : delta;
	else
	    MouseY -= (0x80 <= (delta = newY-oldMouseY)) ? 0x100-delta : delta;
	oldMouseX = newX;
	oldMouseY = newY;
	MouseButtons = mouseButtons;
	MouseEvent = 1;
	CheckMouseReader();
      }

#ifdef STAR_TREK
    {
    extern QvssKeyboardPutchar();
    static int count = 0;
    count++;
    count = count % 120;
    
    if (count % 20 == 0){
	if (count == 0){
	    QvssKeyboardPutchar( QV_LED_ENABLE );
	    QvssKeyboardPutchar( LED_1 );
	    QvssKeyboardPutchar( QV_LED_DISABLE );
	    QvssKeyboardPutchar( LED_2 );
	}else if (count == 20){
	    QvssKeyboardPutchar( QV_LED_ENABLE );
	    QvssKeyboardPutchar( LED_2 );
	    QvssKeyboardPutchar( QV_LED_DISABLE );
	    QvssKeyboardPutchar( LED_1 );
	}else if (count == 40){
	    QvssKeyboardPutchar( QV_LED_ENABLE );
	    QvssKeyboardPutchar( LED_3 );
	    QvssKeyboardPutchar( QV_LED_DISABLE );
	    QvssKeyboardPutchar( LED_2 );
	}else if (count == 60){
	    QvssKeyboardPutchar( QV_LED_ENABLE );
	    QvssKeyboardPutchar( LED_4 );
	    QvssKeyboardPutchar( QV_LED_DISABLE );
	    QvssKeyboardPutchar( LED_3 );
	}else if (count == 80){
	    QvssKeyboardPutchar( QV_LED_ENABLE );
	    QvssKeyboardPutchar( LED_3 );
	    QvssKeyboardPutchar( QV_LED_DISABLE );
	    QvssKeyboardPutchar( LED_4 );
	}else if (count == 100){
	    QvssKeyboardPutchar( QV_LED_ENABLE );
	    QvssKeyboardPutchar( LED_2 );
	    QvssKeyboardPutchar( QV_LED_DISABLE );
	    QvssKeyboardPutchar( LED_3 );
	}
    }
    }
#endif STAR_TREK
  }
    
