/* things specific to the Qvss keyboard, include keymaps */

/* Keycodes for the Qvss keyboard */
#define QV_KEY_SHIFT	0xae
#define QV_KEY_LOCK	0xb0
#define QV_KEY_REPEAT	0xb4
#define QV_KEY_CNTRL	0xaf
#define QV_KEY_ALLUP	0xb3


/*
* Stolen from Ultrix driver -- you might want to retype it all in
* so that we can't be sued.
*/
char QvssKeyTable[]={
	 0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*   0 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*   8 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00	/*  16 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  24 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  32 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  40 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  48 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  56 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  64 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  72 */ 
#ifdef FUNCTIONS
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x81 ,0x82 /*  80 */
	,0x83 ,0x84 ,0x85 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  88 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x86 ,0x87 ,0x88 ,0x89 /*  96 */
	,0x8a ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 104 */ 
#else /* Make all first group of function keys into ESCAPE */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x1b ,0x1b /*  80 */
	,0x1b ,0x1b ,0x1b ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  88 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x1b ,0x1b ,0x1b ,0x1b /*  96 */
	,0x1b ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 104 */ 
#endif
	,0x00 ,0x1b ,0x08 ,0x0a ,0x8b ,0x00 ,0x00 ,0x00 /* 112 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x8c ,0x8d ,0x00 ,0x00 /* 120 */
	,0x8e ,0x8f ,0x90 ,0x91 ,0x00 ,0x00 ,0x00 ,0x00 /* 128 */
	,0x00 ,0x00 ,0x92 ,0x93 ,0x94 ,0x95 ,0x96 ,0x97 /* 136 */
	,0x00 ,0x00 ,0xa0 ,0x00 ,0xa1 ,0xa2 ,0xa3 ,0xa4 /* 144 */
	,0xa5 ,0xa6 ,0xa7 ,0xa8 ,0xa9 ,0xaa ,0xab ,0xac /* 152 */
	,0xad ,0x98 ,0x99 ,0x9a ,0x9b ,0x00 ,0x00 ,0x9c /* 160 */
	,0x9d ,0x9e ,0x9f ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 168 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 176 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x7f ,'\r' ,0x09 ,'`'  /* 184 */
	,'1'  ,'q'  ,'a'  ,'z'  ,0x00 ,'2'  ,'w'  ,'s'  /* 192 */
	,'x'  ,'<'  ,0x00 ,'3'  ,'e'  ,'d'  ,'c'  ,0x00 /* 200 */
	,'4'  ,'r'  ,'f'  ,'v'  ,' '  ,0x00 ,'5'  ,'t'  /* 208 */
	,'g'  ,'b'  ,0x00 ,'6'  ,'y'  ,'h'  ,'n'  ,0x00 /* 216 */
	,'7'  ,'u'  ,'j'  ,'m'  ,0x00 ,'8'  ,'i'  ,'k'  /* 224 */
	,','  ,0x00 ,'9'  ,'o'  ,'l'  ,'.'  ,0x00 ,'0'  /* 232 */
	,'p'  ,0x00 ,';'  ,'/'  ,0x00 ,'='  ,']'  ,'\\' /* 240 */
	,0x00 ,'-'  ,'['  ,'\'' ,0x00 ,0x00 ,0x00 ,0x00 /* 248 */
};

char QvssShiftKeyTable[]={
	 0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*   0 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*   8 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00	/*  16 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  24 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  32 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  40 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  48 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  56 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  64 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  72 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x81 ,0x82 /*  80 */
	,0x83 ,0x84 ,0x85 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /*  88 */ 
	,0x00 ,0x00 ,0x00 ,0x00 ,0x86 ,0x87 ,0x88 ,0x89 /*  96 */
	,0x8a ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 104 */ 
	,0x00 ,0x1b ,0x08 ,0x0a ,0x8b ,0x00 ,0x00 ,0x00 /* 112 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x8c ,0x8d ,0x00 ,0x00 /* 120 */
	,0x8e ,0x8f ,0x90 ,0x91 ,0x00 ,0x00 ,0x00 ,0x00 /* 128 */
	,0x00 ,0x00 ,0x92 ,0x93 ,0x94 ,0x95 ,0x96 ,0x97 /* 136 */
	,0x00 ,0x00 ,0xa0 ,0x00 ,0xa1 ,0xa2 ,0xa3 ,0xa4 /* 144 */
	,0xa5 ,0xa6 ,0xa7 ,0xa8 ,0xa9 ,0xaa ,0xab ,0xac /* 152 */
	,0xad ,0x98 ,0x99 ,0x9a ,0x9b ,0x00 ,0x00 ,0x9c /* 160 */
	,0x9d ,0x9e ,0x9f ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 168 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 /* 176 */
	,0x00 ,0x00 ,0x00 ,0x00 ,0x7f ,'\r' ,0x09 ,'~'  /* 184 */
	,'!'  ,'Q'  ,'A'  ,'Z'  ,0x00 ,'@'  ,'W'  ,'S'  /* 192 */
	,'X'  ,'>'  ,0x00 ,'#'  ,'E'  ,'D'  ,'C'  ,0x00 /* 200 */
	,'$'  ,'R'  ,'F'  ,'V'  ,' '  ,0x00 ,'%'  ,'T'  /* 208 */
	,'G'  ,'B'  ,0x00 ,'^'  ,'Y'  ,'H'  ,'N'  ,0x00 /* 216 */
	,'&'  ,'U'  ,'J'  ,'M'  ,0x00 ,'*'  ,'I'  ,'K'  /* 224 */
	,'<'  ,0x00 ,'('  ,'O'  ,'L'  ,'>'  ,0x00 ,')'  /* 232 */
	,'P'  ,0x00 ,':'  ,'?'  ,0x00 ,'+'  ,'}'  ,'|'  /* 240 */
	,0x00 ,'_'  ,'{'  ,'"'  ,0x00 ,0x00 ,0x00 ,0x00 /* 248 */
};

/*
 * LK201 special purpose keys. Translations from the tables above
 * includes codes for the function keys and other goodies. They can
 * be determined by the presence of the 8th bit being set.  The 
 * following table is accessed by removing that bit and using the 
 * result as the index to the following table. Note that table begins
 * a null entry.
 */
char	*QvssSpecialKeyTable[]={ 0,
	"\33[11~",			/* f1 */
	"\33[12~",			/* f2 */
	"\33[13~",			/* f3 */
	"\33[14~",			/* f4 */
	"\33[15~",			/* f5 */
	"\33[17~",			/* f6 */
	"\33[18~",			/* f7 */
	"\33[19~",			/* f8 */
	"\33[20~",			/* f9 */
	"\33[21~",			/* f10 */
	"\33[26~",			/* f14 */
	"\33[28~",			/* f15 */
	"\33[29~",			/* f16 */
	"\33[31~",			/* f17 */
	"\33[32~",			/* f18 */
	"\33[33~",			/* f19 */
	"\33[34~",			/* f20 */
	"\33[1~",			/* find */
	"\33[2~",			/* insert */
	"\33[3~",			/* remove */
	"\33[4~",			/* select */
	"\33[5~",			/* prev */
	"\33[6~",			/* next */
	"\33OP",			/* pf1 */
	"\33OQ",			/* pf2 */
	"\33OR",			/* pf3 */
	"\33OS",			/* pf4 */
	"\33[D",			/* left */
	"\33[C",			/* right */
	"\33[B",			/* down */
	"\33[A",			/* up */
	"\33Op",			/* key pad 0 */
	"\33On",			/* key pad . */
	"\33OM",			/* key pad enter */
	"\33Oq",			/* key pad 1 */
	"\33Or",			/* key pad 2 */
	"\33Os",			/* key pad 3 */
	"\33Ot",			/* key pad 4 */
	"\33Ou",			/* key pad 5 */
	"\33Ov",			/* key pad 6 */
	"\33O/*",			/* key pad , */
	"\33Ow",			/* key pad 7 */
	"\33Ox",			/* key pad 8 */
	"\33Oy",			/* key pad 9 */
	"\33Om",			/* key pad - */
	/*
	 * The following strings are to allow a numeric keypad
	 * mode and still use the same translation tables
	 */
	"0",
	".",
	"\r",
	"1",
	"2",
	"3",
	"4",
	"5",
	"6",
	",",
	"7",
	"8",
	"9",
	"-"
};

