/*
 * Distributed V Kernel
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 * (Transliterated from Zed and Verex Kernel)
 *
 * Perform "reboot request".
 */

#include "process.h"

InitReboot( pd )
Process *pd;
  {
    /* Process a reboot request. unspecified[0&1] contain the minimum and
     * maximum times (in minutes) to delay before rebooting. This is done
     * to prevent flooding the boot server. If the reboot isn't immediate
     * delay for a fraction of a minute before entering the countdown
     * to further prevent flooding.
     */
    Unspec RebootTimeout();
    register Process *alien;
    register KernelRequest *req = (KernelRequest *) &pd->msg;

    if (Local(pd->pid) && (pd->forwarder & GROUP_ID_BIT))
	return( DISCARD_REPLY );
/*  if ( (pd->userNumber != SYSTEM_USER) && (pd->userNumber != SUPER_USER) )
	return( NO_PERMISSION );
 */
    req->unspecified[0] += (GenerateRandomNumber() % 
	          (req->unspecified[1] - req->unspecified[0]));
    if (req->unspecified[0])
      {
        if ((alien = (Process *) AllocatePd()) == NULL) Reboot();
	((KernelRequest *) &alien->msg)->unspecified[0] = req->unspecified[0];
	alien->timeout_func = RebootTimeout;
	alien->timeout_count = GenerateRandomNumber() % (60 * CLICKS_PER_SEC);
	DelayProcess( alien );
      }
    else Reboot();
    return( OK );
  }
  
Unspec RebootTimeout( pd )
Process *pd;
  {
    /* If the countdown has reached zero reboot. Otherwise delay for a minute.
     * Display a warning if we're in the right mood and the time is right.
     */
    register KernelRequest *req = (KernelRequest *) &pd->msg;
    register timeToLive = req->unspecified[0];
    register message = 0;
    
    if ( timeToLive == 0 ) Reboot();
	
    if ( timeToLive >= 20 )
      {
	if ( ( timeToLive % 5 ) == 0 ) message = 1;
      }
    else if ( timeToLive > 10 )
      {
	if ( ( timeToLive & 3 ) == 0 ) message = 1;
      }
    else message = 1;

    if ( message )
        printx("This workstation will reboot in %d minute%s.\n", 
					timeToLive,
					(timeToLive != 1)?"s":"");
    req->unspecified[0] = --timeToLive;
    pd->timeout_func = RebootTimeout;
    pd->timeout_count = CLICKS_PER_SEC * 60;
    DelayProcess( pd );
  }
