/*
 * Distributed V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Kernel naming support - very primitive
 *
 */

#include "Venviron.h"
#include "Vgroupids.h"
#include "process.h"
#include "naming.h"

extern Process *Active;
Logical_id_entry Logical_id_map[MAX_LOGICAL_ID+1];

SetPid( active ) 
   register Process *active;

  /* Set the logical id to be the specified pid.
   */
  {
    extern Logical_id_entry Logical_id_map[];
    register KernelRequest *req;
    register Process_id pid;
    unsigned logical_id;
    unsigned char scope;

    req = (KernelRequest *) &active->msg;
    pid = req->pid;
    logical_id = req->unspecified[0];
    scope = (unsigned char) req->unspecified[1];

    if( logical_id > MAX_LOGICAL_ID ) return( BAD_ARGS );
    Logical_id_map[logical_id].pid = pid;
    if( (scope!=LOCAL_PID) && (scope!=ANY_PID) ) return( BAD_ARGS );
    Logical_id_map[logical_id].scope = scope;
    return( OK );
  }

FinishGetPid( pd )
register Process *pd;
  {
    register KernelRequest *req = (KernelRequest *) &pd->msg;
#ifdef DEBUG
{register int *i = (int *)&pd->msg;

printx("Ret(%x) -> %x: %x %x %x %x %x %x %x %x\n",
pd->blocked_on, pd->pid, i[0], i[1], i[2], i[3], i[4], i[5], i[6], i[7]);}
#endif
    Addready( pd );
    return((req->opcode != OK) ? 0 : req->pid );
  }

Process_id GetPid( logical_id, scope ) 
register unsigned logical_id; unsigned char scope;

  /* Return the pid corresponding to the logical_id.
   */
  {
    extern Process_id KernelServerPid;
    register Process *pd = Active;
    register KernelRequest *req;

    pd->finish_up = (Unspec (*)()) FinishGetPid;
    pd->forwarder = pd->pid;
    pd->blocked_on = KernelServerPid;
    req = (KernelRequest *) &pd->msg;
    req->opcode = GET_PID;
    req->pid = logical_id;
    req->unspecified[0] = (unsigned) logical_id;
    req->unspecified[1] = (unsigned) scope;
    KSend( pd );
    return( NO_REPLY );
  }

SystemCode GetRealPid( pd )
    register Process *pd;
  /* Return the pid corresponding to the logical_id.
   */
  {
    extern ProcessId Device_Server_Pid, KernelServerPid;
    extern Logical_id_entry Logical_id_map[];
    register KernelRequest *req = (KernelRequest *) &pd->msg;
    register unsigned logical_id, scope;
    register ProcessId pid;
    Process *pd1;

    logical_id = (unsigned) req->unspecified[0];
    scope = (unsigned char) req->unspecified[1];
    
    if( logical_id > MAX_LOGICAL_ID )
	return( ( IsGroupId( pd->forwarder ) ) ? DISCARD_REPLY : BAD_ARGS );

    if( logical_id == ACTIVE_PROCESS )  pid = pd->pid;
    else if( logical_id == DEVICE_SERVER )  pid = Device_Server_Pid;
    /*
     * Temporary switch-over cases for transition to using local process groups
     * to access the kernel and team server. 
     */
    else if( logical_id == KERNEL_PROCESS )
      {
	pid = PidLhn(pd->pid) | LKERNEL_SERVER_GROUP;
      }
    else if( logical_id == TEAM_SERVER )
      {
	pid = PidLhn(pd->pid) | LTEAM_SERVER_GROUP;
      }

    else 
      {
	pid = Logical_id_map[logical_id].pid;

	/* Special scope check: Foreign processes looking for ANY_PID
	 * should only find a local processes registered as ANY_PID.
	 */
	if ( !Local( pd->pid ) && IsGroupId( pd->forwarder ) &&
	     ( scope == ANY_PID ) &&
	     ( Logical_id_map[logical_id].scope != ANY_PID ) )
	    return( DISCARD_REPLY );

	/* Is this a valid pid ? */
	if ( !IsGroupId( pid ) && !MAP_TO_RPD( pd1, pid ) )
	  {
	    if ( IsGroupId( pd->forwarder ) &&
	         ( pd->forwarder != LKERNEL_SERVER_GROUP ) )
		return( DISCARD_REPLY );
	    else
		pid = INVALID_PROCESS;		
	  }
      }

    if ( pid != INVALID_PROCESS )
      {
	req->pid = pid;
	return( OK );
      }

    /* If we didn't find the pid here and we will accept ANY_PID then
     * forward the request to the kernel server group. Otherwise
     * return NOT_FOUND. Group sends have already been dealt with.
     */
    if ( Local( pd->pid ) && ( scope == ANY_PID ) )
      {
	/* Forward msg to the kernel server group to see defined remotely. */
	pd->forwarder = pd->blocked_on;
	pd->blocked_on = VKERNEL_SERVER_GROUP;
	/* Note: this will queue an alien sending to this kernel server
	 * because the kernel server is a local member of this group.
	 */
	KSend( pd );
	return( NO_REPLY );
      }

    return( NOT_FOUND );
  }
